/*********************************
* sevenSegmentLed Library Example
*
* This program by one every second counts, do a 4-digit seven-segment LED display.
*
* seven segment numeric LED Display : LTC4627P
*       http://www.excesssolutions.com/mas_assets/acrobat/ES5721.pdf
*
*  LTC4627T                              Resister        mbed
*  Pin No     Function                   [ohm]           Function
*  ---------------------------------------------------------------------------
*   1         Common Anode Digit 1        -              P29 
*   2         Common Anode Digit 2        -              P13
*   3         Cathode D                   200            P22
*   4         Common Anode L1,L2,L3       -              -
*   5         Cathode E                   200            P24
*   6         Common Anode Digit 3        -              P25  
*   7         Cathode D.p.                200            P30
*   8         Common Anode Digit 4        -              P27 
*   9         No Connection               -              -
*  10         No Pin                      -              -
*  11         Cathode F                   200            P16 
*  12         No Pin                      -              -
*  13         Cathode C,L3                200            P17 
*  14         Cathode A,L1                200            P14
*  15         Cathode G                   200            P19
*  16         Cathode B,L2                200            P20



**********************************/
#include "mbed.h"

#include "SevenSegLed.h"

//                     common type (0:anode common 1:cathode common)
//                     |
//                     |  display mode (0:smooth 1:hard)
//                     |  |
//                     |  |    segA segB segC segD segE segF segG segP com1 com2 com3 com4                           
//                     |  |    |    |    |    |    |    |    |    |    |    |    |    | 
SevenSegLed segmentled(0, 0, p14, p20, p17, p22, p24, p16, p19, p30, p29, p13, p25, p27);


//                   1  2  3  4digit 
//                   |  |  |  |
uint8_t D_7seg[4] = {0, 0, 0, 0}; // seven segment digit number    (0x00:"0", 0x01:"1", ... , 0x09:"9", 0x0A:"A", ... , 0x0F:"F", other:" ")
uint8_t D_dot[4]  = {0, 0, 0, 0}; // seven segment digit dotpoint. (0:off 1:on)


Timer timer;    // 1second timer
    
int main() {
    uint16_t counter = 0;
    
    timer.start();

    while(1) {
        // After one second to start the process
        if(timer.read_ms() >= 1000){
            timer.reset();
            counter++;

            // Display digit data updates
            D_7seg[0] = (uint8_t)((counter & 0xF000) >> 12);
            D_7seg[1] = (uint8_t)((counter & 0x0F00) >> 8);
            D_7seg[2] = (uint8_t)((counter & 0x00F0) >> 4);
            D_7seg[3] = (uint8_t)(counter & 0x000F);
            
            // Display dot point data updates
            D_dot[0] = 0;
            D_dot[1] = 0;
            D_dot[2] = 0;
            D_dot[3] = 0;            
            
            // dot point data set
            D_dot[counter & 0x0003] = 1;
        }

        // seven segment display to output data
        // This function, please repeat the process in less than 1ms.
        segmentled.SevenSegLed_main(D_7seg, D_dot);      
 
    }
}
