#define LCD


#include "mbed.h"
#include "testLed.h"
#include "testSound.h"
#include "priodMsurement.h"
#include "DigitalSw.h"


#ifdef LCD
#include <AQM0802A.h>
I2C i2c(p28, p27);
AQM0802A lcd(i2c);    // if 5.0v supply, (i2c, false);
#endif // LCD

//DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
//DigitalOut myled3(LED3);
//DigitalOut myled4(LED4);

//DigitalIn demoLedSw(p20, PullUp);

DigitalSw startSw(p25);
DigitalSw upSw(p30);
DigitalSw downSw(p29);

int main()
{
    int8_t p = 0;
    int8_t point = 0;
    int32_t loPriod;
    int32_t hiPriod;

    priodMsurementInitalize();
    testLedInitalize();
    testSoundInitalize();

    int count =0;

    while(1) {
        myled2 = !myled2;

#ifdef CHECKSIGNAL
        testSoundMain(!demoLedSw);
        testLedMain(!demoLedSw);
#endif

        priodMsurementMain();

        if(upSw.getOnEdge() == 1) {
            if(++p >= 50) {
                p = 49;
            }
        }

        if(downSw.getOnEdge() == 1) {
            if(--p <= 0) {
                p = 0;
            }
        }

        if(startSw.getOnEdge() == 1) {
            priodMsurementRequest();
            }

#ifdef LCD
        point = p;
        if(true ==  surementData(&point, &hiPriod, &loPriod)) {
            lcd.cls();
            lcd.printf("p=%2d hi = %4d\n",point, hiPriod);
            lcd.printf("mem  lo = %4d",loPriod);
            wait(0.2);
        } else {
            p = 0;
            lcd.cls();
            lcd.printf("p=%2d hi = %4d\n",point, hiPriod);
            lcd.printf("smp  lo = %4d",loPriod);
            wait(0.2);
        }
#endif // LCD

    }

}
