#include "mbed.h"
#include "testLed.h"

void tick(void);
Ticker ticker;
DigitalOut myled3(LED3);
DigitalOut dbgLedPort(p25);

DigitalOut testLed(LED1);

Timer timerTestLed;
bool brinkRequest = false;



void testLedInitalize(void)
{
    timerTestLed.start();
    timerTestLed.reset();
    brinkRequest = false;

    ticker.attach_us(&tick, 1000);
}

uint8_t brinkPosition = 0;  // brinkPattern[][ここ]
uint16_t brinkPriod = 0;    // 点滅時間 1/1 ([ms]/count)
bool testLedLevel = false;  // false:Off true:On
uint32_t brinkPattern[][2] = {
    {1,100},
    {0,100},

    {1,200},
    {0,200},

    {1,300},
    {0,300},

    {1,400},
    {0,400},

    {1,500},
    {0,500},

    {1,100},
    {0,200},

 


    {2,0}       // end
};

void tick(void)
{
    dbgLedPort = !dbgLedPort;
    myled3 = !myled3;
    if(testLedLevel == true) {
        testLed = !testLed;
    } else {
        testLed = 0;
    }
}



bool testLedMain(bool request)
{
    if(brinkRequest == false) {
        if(request == true) {
            brinkRequest = true;
            brinkPosition = 0;
            testLedLevel = brinkPattern[brinkPosition][0];
            brinkPriod = brinkPattern[brinkPosition][1];

            timerTestLed.reset();
        } else {
            // nothing
        }
    } else {
        if(timerTestLed.read_ms() > brinkPriod) {
            brinkPosition++;
            if(brinkPattern[brinkPosition][0] == 2) {
                testLedLevel = 0;
                brinkRequest = false;
            } else {
                testLedLevel = brinkPattern[brinkPosition][0];
                brinkPriod = brinkPattern[brinkPosition][1];
                timerTestLed.reset();

            }
        }
    }
    return (brinkRequest);
}