#include "mbed.h"
#include "priodMsurement.h"

Timer hiTimer;  // hi priod timer
Timer loTimer; // low priod timer
Timer aTimer;

Ticker checkTicker;

int32_t hiCompleteTime;    // 1/1 [ms]/count
int32_t loCompleteTime;


int32_t D_surement[50][2];  // LCD表示用測定値保管
int8_t P_surement = 0;     // D_surement[ここ][] のポインタ
#define Z_nonSurement (-1)  // D_surementの最終位置(不定値)

bool F_start = false; // 測定開始要求 false:なし true:あり
void priodMsurementRequest(void)
{
    F_start = true;
    }


int8_t beforeLevel = -1; // 0:Lo 1:Hi -1:timeOut(non Pluse)

#define Z_initialSurement (-1)// surementPut()への初期化指示
#define Z_hiSurement (0)     // surementPut()へのON時間記憶指示
#define Z_loSurement (1)     // surementPut()へのOFF時間記憶指示
void surementPut(int8_t hilo, int32_t surement)
{
    if(hilo == Z_initialSurement) {
        P_surement = 0;
        D_surement[P_surement][Z_hiSurement] = (int32_t)Z_initialSurement;
        D_surement[P_surement][Z_loSurement] = (int32_t)Z_initialSurement;
    } else {
        D_surement[P_surement][hilo] = surement;
        D_surement[P_surement + 1][hilo] = (int32_t)Z_initialSurement;

        if(hilo == Z_loSurement) {
            P_surement++;
        }
    }
}

InterruptIn lightIn(p18);
DigitalOut monitor(LED4);
bool surementData(int8_t *p, int32_t *hiPriod, int32_t *loPriod)
{
    bool ans = beforeLevel == -1 ? true : false;
    if(ans == false) {
        *p = P_surement;
    }
    *hiPriod = D_surement[*p][Z_hiSurement];
    *loPriod = D_surement[*p][Z_loSurement];

    return (ans);
}

void priodMsurementMain(void)
{


}

void hiEdge(void)
{
    hiTimer.reset();
    if(beforeLevel == 0) {
        loCompleteTime = loTimer.read_ms();
        surementPut(Z_loSurement, loCompleteTime);
        beforeLevel = 1;
        printf("hi = %d,  lo = %d\r\n",hiCompleteTime, loCompleteTime);
    }
//    if(beforeLevel == -1) {
    if((beforeLevel == -1) && (F_start == true)) {
        printf("start\r\n");
        surementPut(Z_initialSurement, (int32_t)Z_initialSurement);
        beforeLevel = 1;
        F_start = false;
    }
    monitor = 1;
}

void loEdge(void)
{
    loTimer.reset();
    if(beforeLevel == 1) {
        hiCompleteTime = hiTimer.read_ms();
        surementPut(Z_hiSurement, hiCompleteTime);
    beforeLevel = 0;
    }
    monitor = 0;
}

void pulseCheck(void)
{
    int32_t lo = loTimer.read_ms();
    int32_t hi = hiTimer.read_ms();

    if((lo > Z_nonSignalTime) && (beforeLevel == 0)) {
        // pulse end
        beforeLevel = -1;

        printf("hi = %d,  lo = --\r\n",hiCompleteTime);
        printf("end\r\n");
    }


}

void priodMsurementInitalize(void)
{
    aTimer.start();
    hiTimer.start();
    loTimer.start();
    checkTicker.attach_us(&pulseCheck, 1000);

    lightIn.rise(&hiEdge);
    lightIn.fall(&loEdge);
}
