#include "mbed.h"
#include "testSound.h"

void tickSound(void);
Ticker tickSounder;

DigitalOut dbgSoundPort(p22);
DigitalOut testSound(p21);

Timer timerTestSound;
bool brinkRequestSound = false;



void testSoundInitalize(void)
{
    timerTestSound.start();
    timerTestSound.reset();
    brinkRequestSound = false;

    tickSounder.attach_us(&tickSound, 250);
}

uint8_t brinkPositionSound = 0;  // brinkPatternSound[][ここ]
uint16_t brinkPriodSound = 0;    // 点滅時間 1/1 ([ms]/count)
bool testSoundLevel = false;  // false:Off true:On
uint32_t brinkPatternSound[][2] = {
    {1,100},
    {0,100},

    {1,200},
    {0,200},

    {1,300},
    {0,300},

    {1,400},
    {0,400},

    {1,500},
    {0,500},

    {1,100},
    {0,200},

 


    {2,0}       // end
};

void tickSound(void)
{
    dbgSoundPort = !dbgSoundPort;
    if(testSoundLevel == true) {
        testSound = !testSound;
    } else {
        testSound = 0;
    }
}



bool testSoundMain(bool request)
{
    if(brinkRequestSound == false) {
        if(request == true) {
            brinkRequestSound = true;
            brinkPositionSound = 0;
            testSoundLevel = brinkPatternSound[brinkPositionSound][0];
            brinkPriodSound = brinkPatternSound[brinkPositionSound][1];

            timerTestSound.reset();
        } else {
            // nothing
        }
    } else {
        if(timerTestSound.read_ms() > brinkPriodSound) {
            brinkPositionSound++;
            if(brinkPatternSound[brinkPositionSound][0] == 2) {
                testSoundLevel = 0;
                brinkRequestSound = false;
            } else {
                testSoundLevel = brinkPatternSound[brinkPositionSound][0];
                brinkPriodSound = brinkPatternSound[brinkPositionSound][1];
                timerTestSound.reset();

            }
        }
    }
    return (brinkRequestSound);
}