/***********************************************************************/
/*                                                                     */
/*    tokei.c                                                          */
/*                                                                     */
/***********************************************************************/
#define _TOKEI_C

#include "mbed.h"
#include "math.h"

#include "tokei.h"
#include "display.h"
#include "dotmatrix.h"
#include "NTPClient.h"
#include "NTP.h"

//#define DBG

/*****************************Macro definition********************************/

/*****************************Global variable*********************************/

/******************************Function declaration***************************/
static void tokei_jikokuKeiji(_JIKOKU *j);
static void tokei_byoHyoji(_JIKOKU j);
static void tokei_funHyoji(_JIKOKU j);
static void tokei_jiHyoji(_JIKOKU j);
static void tokei_amPmHyoji(_JIKOKU j);
static _DISPLAYPOSITION tokei_byoIti(uint8_t sec);
static _DISPLAYPOSITION tokei_jiIti(uint8_t ji, uint8_t min);
static void tokei_mojibanByo(void);
static void tokei_mojibanJi(void);


/******************************************************************************
Name       : jikoku keiji
Parameters : none
Returns    : nothing
Description: 100ms call
******************************************************************************/

void tokei_main(void)
{

    tokei_jikokuKeiji(&D_genzaiJikoku);
    
    // genzai jikoku hyoji
    tokei_funHyoji(D_genzaiJikoku);
    tokei_byoHyoji(D_genzaiJikoku);     // fun no dot wo henko suru no de tokei_funHyoji()no ato ni jittko
    tokei_jiHyoji(D_genzaiJikoku);
    
    // mojiban hyoji
    tokei_amPmHyoji(D_genzaiJikoku);
    tokei_mojibanByo();
    tokei_mojibanJi();
    
    // TLC5940 heno kakikae wo siteinaitoki ni hyoji data kosin
    if(F_kakikae == 0){
        // hyoji data kakikae OK
        for(uint8_t x = 0; x < 16; x++){
            for(uint8_t y = 0; y < 16; y++){
                B_display[Z_green][x][y] = D_display[Z_green][x][y];
                B_display[Z_red][x][y] = D_display[Z_red][x][y];
            }
        }
    }
}

/******************************************************************************
Name       : jikoku keiji (debug)
Parameters : none
Returns    : nothing
Description: 10ms call
******************************************************************************/
#ifndef DBG
static void tokei_jikokuKeiji(_JIKOKU *j)
{
    static uint8_t secBuffer = 0;
    time_t ctTime;
    struct tm *jst_time;
    
    _JIKOKU wk = *j;


    ctTime = time(NULL);
    ctTime += 32400;
    jst_time = localtime(&ctTime);

    
    wk.sec  = jst_time->tm_sec;
    wk.min  = jst_time->tm_min;
    wk.hour = jst_time->tm_hour;
    
    // dammy ms data setup
    if(wk.msec < 99){wk.msec++;}
    if(secBuffer != wk.sec){
        wk.msec = 0;
        secBuffer = wk.sec;
    }
    
    *j = wk;
    
/* NTP wo tukawanai toki no code
    _JIKOKU wk = *j;

    wk.msec++;
    if(wk.msec > 99){
        wk.msec = 0;
        wk.sec++;
        if(wk.sec > 59){
            wk.sec = 0;
            wk.min++;
            if(wk.min > 59){
                wk.min = 0;
                wk.hour++;
                if(wk.hour > 23){
                    wk.hour = 0;
                }
            }
        }
    }
    *j = wk;
*/
}
#else // DBG
static void tokei_jikokuKeiji(_JIKOKU *j)
{
   _JIKOKU wk = *j;

    wk.msec++;
    if(wk.msec > 99){
        wk.msec = 0;
        wk.sec++;
        if(wk.sec > 59){
            wk.sec = 0;
            wk.min++;
            if(wk.min > 59){
                wk.min = 0;
                wk.hour++;
                if(wk.hour > 23){
                    wk.hour = 0;
                }
            }
        }
    }
    *j = wk;
}
#endif // DBG

/******************************************************************************
Name       : byo hyoji
Parameters : none
Returns    : nothing
Description: 10ms ika no syuki de call
******************************************************************************/
static void tokei_byoHyoji(_JIKOKU j)
{
    uint8_t c = j.sec;
    uint8_t i;
    int8_t red;

    _DISPLAYPOSITION iti;
    _DISPLAYCOLOR color;

    // kako no tento kasyo wo 1s goto ni 1dankai zutu syoto
    for(i = 0; i < 60; i++){
        
        iti = tokei_byoIti(i);
        if((j.msec % 10) == 0){
            if(D_display[Z_green][iti.x][iti.y] > 0){
                D_display[Z_green][iti.x][iti.y] -=1;
            }
        }

        uint8_t j1 = j.min + 1;
        if(j1 > 60){j1 = 0;}
        if((D_display[Z_green][iti.x][iti.y] > 0) && ((j.min != i) && ((j1 != i )))){
            // red to green ga kasanaru tokoto ha red wo genko suru 
            // (genzai ji to 59s kara 0s deno senko hyoji no red ha genko kara jogai) 
            red = D_display[Z_red][iti.x][iti.y] - D_display[Z_green][iti.x][iti.y];
            if(red < 0){
                red = 0;
            }
            D_display[Z_red][iti.x][iti.y] = (uint8_t)red;
         }
    }
    
    // genzai no byo iti wo 100ms goto ni 1dankai zutu tento
    iti = tokei_byoIti(c);

    color.r = Z_colorNull;
    color.g = ((uint16_t)j.msec * Z_colorMax) / 99;
    display_pset(color, iti);
    
}

/******************************************************************************
Name       : fun hyoji(byo to onaji iti ni hyoji)
Parameters : none
Returns    : nothing
Description: 10msec ika no syuki de call
******************************************************************************/
static void tokei_funHyoji(_JIKOKU j)
{
    static uint8_t clearflag = 0;    // 59min to 0min clear flag
    uint8_t c = j.min;

//    static _JIKOKU zenkaiJikoku = {0, 0, 1, 0};

    _DISPLAYPOSITION iti;
    _DISPLAYCOLOR color;
    
    // 0min no toki no clear yo
    _DISPLAYPOSITION p0;
    _DISPLAYPOSITION p1;


    // 1jikan keika go no fun dot clear
    switch(clearflag){
    case 0:
        if(c == 59){clearflag = 1;}
        break;
    case 1:
        if(c == 0){
            color.g = Z_colorNull;
            if(j.sec == 0){
                color.r = Z_colorMax - ((uint16_t)j.msec * Z_colorMax) / 99;
            }
            else{
                color.r = 0;
                clearflag = 0;
            }
            p0.x = 0;
            p0.y = 0;
            p1.x = 15;
            p1.y = 0;
            display_line(color, p0, p1);
            p0.x = 15;
            p0.y = 0;
            p1.x = 15;
            p1.y = 15;
            display_line(color, p0, p1);
            p0.x = 15;
            p0.y = 15;
            p1.x = 0;
            p1.y = 15;
            display_line(color, p0, p1);
            p0.x = 0;
            p0.y = 15;
            p1.x = 0;
            p1.y = 0;
            display_line(color, p0, p1);
        }
    default:
        // nothing
        break;      
    }
    
    // fun dot no reflesh
    for(uint8_t i = 0; i < c; i++){
        iti = tokei_byoIti(i);
        color.r = Z_colorMax;
        color.g = Z_colorNull;
        display_pset(color, iti);
    }
 
    // genzai no byo iti wo 1s goto ni 1dankai zutu tento
    iti = tokei_byoIti(c);

    if((j.sec & 0x01) == 0){
        // genzai fun no tenmetu hyoji
        color.r = Z_colorMax - ((uint16_t)j.msec * Z_colorMax) / 99;
    }
    else{
        color.r = ((uint16_t)j.msec * Z_colorMax) / 99;
    }

    color.g = Z_colorNull;
    display_pset(color, iti);
    
    // 59s to 0s deno tugi no fun dot senko hyoji
    if(j.sec == 59){
        uint8_t ctugi = c + 1;
        if(ctugi > 59){
            ctugi = 0;
        }
        iti = tokei_byoIti(ctugi);
        color.r = ((uint16_t)j.msec * Z_colorMax) / 99;
    
        color.g = Z_colorNull;
        display_pset(color, iti);
    }
}

/******************************************************************************
Name       : ji hyoji(chusin yori 5syume de hyoji) 3dot 1jikan
Parameters : none
Returns    : nothing
Description: 1jikan ika no syuki de call
******************************************************************************/
static void tokei_jiHyoji(_JIKOKU j)
{
    static uint8_t clearflag = 0;

    uint8_t ji;
    uint8_t jiIti;
    _DISPLAYPOSITION iti;
    _DISPLAYCOLOR color;
    
    // 0ji no clear yo
    _DISPLAYCOLOR c = {0, 0};
    _DISPLAYPOSITION p0;
    _DISPLAYPOSITION p1;

    // 24hour to 12hour 
    ji = j.hour;
    if(ji > 11){ji -= 12;}


    // ji dot clear syori (59min to 0min clear)
    switch(clearflag){
    case 0:
        if(ji == 11){clearflag = 1;}
        break;
    case 1:
        if(ji == 0){
            if(j.sec == 0){
                color.r = Z_colorMax - ((uint16_t)j.msec * Z_colorMax) / 99;
                color.g = color.r;
            }
            else{
                color.r = 0;
                color.g = 0;
                clearflag = 0;
            }
            
            p0.x = 3;
            p0.y = 3;
            p1.x = 12;
            p1.y = 3;
            display_line(color, p0, p1);
            p0.x = 12;
            p0.y = 3;
            p1.x = 12;
            p1.y = 12;
            display_line(color, p0, p1);
            p0.x = 12;
            p0.y = 12;
            p1.x = 3;
            p1.y = 12;
            display_line(color, p0, p1);
            p0.x = 3;
            p0.y = 12;
            p1.x = 3;
            p1.y = 3;
            display_line(color, p0, p1);
        }
    default:
        // nothing
        break;
    }    

    // kako no ji dot wo tento
    color.r = Z_colorMax;
    color.g = color.r;
    for(uint8_t jiKako = 0; jiKako < ji; jiKako++){
        for(uint8_t minKako = 0; minKako < 60; minKako += 20){
            iti = tokei_jiIti(jiKako, minKako);
            display_pset(color, iti);
        }
    }
    for(uint8_t minKako = 0; minKako < j.min; minKako += 20){
        iti = tokei_jiIti(ji, minKako);
        display_pset(color, iti);
    }
    
    //*************************
    // genzai ji no dot tenmetu
    //*************************
    iti = tokei_jiIti(ji, j.min);
    if((j.sec & 0x01) == 0){
        // genzai ji no tenmetu hyoji
        color.r = Z_colorMax - ((uint16_t)j.msec * Z_colorMax) / 99;
        color.g = color.r;
    }
    else{
        color.r = ((uint16_t)j.msec * Z_colorMax) / 99;
        color.g = color.r;
    }
    
    display_pset(color, iti);

    //**********************************
    // 20fun goto no  ji dot senko hyoji
    //**********************************
    if(j.sec == 59){
        if((j.min == 19) || (j.min == 39) || (j.min == 59)){
            uint8_t tugiFun = j.min + 1;
            uint8_t tugiJi  = ji;
            if(tugiFun > 59){
                tugiFun = 0;
                tugiJi++;
                if(tugiJi > 11){tugiJi = 0;};
            }    
           
            iti = tokei_jiIti(tugiJi, tugiFun);
            color.r = ((uint16_t)j.msec * Z_colorMax) / 99;
            color.g = color.r;
    
            display_pset(color, iti);
        }
    }
}


/******************************************************************************
Name       : AM/PM hyoji
Parameters : none
Returns    : nothing
Description: 1jikan ika no syuki de call
******************************************************************************/
static void tokei_amPmHyoji(_JIKOKU j)
{
    uint8_t ji = j.hour;
    uint8_t ji12;
    _DISPLAYPOSITION iti;
    _DISPLAYCOLOR color;

    if(ji < 12){ji12 = ji;}
    else{ji12 = ji - 12;}

    // AM/PM no hyoji
    if(ji < 12){
        color.g    = ji12 * 5 + 39;
        color.r = Z_colorMin;
    }
    else{
        color.g = Z_colorMin;
        color.r    = ji12 * 5 + 39;
    }
        
    iti.x = 7;
    iti.y = 7;
    display_pset(color, iti);
    iti.x = 8;
    iti.y = 7;
    display_pset(color, iti);
    iti.x = 7;
    iti.y = 8;
    display_pset(color, iti);
    iti.x = 8;
    iti.y = 8;
    display_pset(color, iti);
    

}

/******************************************************************************
Name       : moji ban (byo bubun)
Parameters : none
Returns    : nothing
Description: 
******************************************************************************/
static void tokei_mojibanByo(void)
{
    _DISPLAYPOSITION iti,iti2;
    _DISPLAYCOLOR color;

    // base line
    color.r = Z_colorMin;
    color.g = 50;

    iti.x = 1;
    iti.y = 1;
    iti2.x = 14;
    iti2.y = 1;
    display_line(color, iti, iti2);

    iti.x = 14;
    iti.y = 1;
    iti2.x = 14;
    iti2.y = 14;
    display_line(color, iti, iti2);

    iti.x = 14;
    iti.y = 14;
    iti2.x = 1;
    iti2.y = 14;
    display_line(color, iti, iti2);

    iti.x = 1;
    iti.y = 14;
    iti2.x = 1;
    iti2.y = 1;
    display_line(color, iti, iti2);


    // 0fun
    iti.x = 1;
    iti.y = 1;
    color.r = Z_colorMax;
    color.g = Z_colorMin;
    display_pset(color, iti);

    // 5fun
    iti.x = 5;
    iti.y = 1;
    color.r = Z_colorMax;
    color.g = Z_colorMax;
    display_pset(color, iti);

    // 10fun
    iti.x = 10;
    iti.y = 1;
    color.r = Z_colorMax;
    color.g = Z_colorMax;
    display_pset(color, iti);

    // 15fun
    iti.x = 14;
    iti.y = 1;
    color.r = Z_colorMax;
    color.g = Z_colorMin;
    display_pset(color, iti);

    // 20fun
    iti.x = 14;
    iti.y = 5;
    color.r = Z_colorMax;
    color.g = Z_colorMax;
    display_pset(color, iti);

    // 25fun
    iti.x = 14;
    iti.y = 10;
    color.r = Z_colorMax;
    color.g = Z_colorMax;
    display_pset(color, iti);

    // 30fun
    iti.x = 14;
    iti.y = 14;
    color.r = Z_colorMax;
    color.g = Z_colorMin;
    display_pset(color, iti);

    // 35fun
    iti.x = 10;
    iti.y = 14;
    color.r = Z_colorMax;
    color.g = Z_colorMax;
    display_pset(color, iti);

    // 40fun
    iti.x = 5;
    iti.y = 14;
    color.r = Z_colorMax;
    color.g = Z_colorMax;
    display_pset(color, iti);

    // 45fun
    iti.x = 1;
    iti.y = 14;
    color.r = Z_colorMax;
    color.g = Z_colorMin;
    display_pset(color, iti);

    // 50fun
    iti.x = 1;
    iti.y = 10;
    color.r = Z_colorMax;
    color.g = Z_colorMax;
    display_pset(color, iti);

    // 55fun
    iti.x = 1;
    iti.y = 5;
    color.r = Z_colorMax;
    color.g = Z_colorMax;
    display_pset(color, iti);
}

/******************************************************************************
Name       : moji ban (ji bubun)
Parameters : none
Returns    : nothing
Description: 
******************************************************************************/
static void tokei_mojibanJi(void)
{
    _DISPLAYPOSITION iti,iti2;
    _DISPLAYCOLOR color;

    // base line
    color.r = Z_colorMin;
    color.g = 50;

    iti.x = 4;
    iti.y = 4;
    iti2.x = 11;
    iti2.y = 4;
    display_line(color, iti, iti2);

    iti.x = 11;
    iti.y = 4;
    iti2.x = 11;
    iti2.y = 11;
    display_line(color, iti, iti2);

    iti.x = 11;
    iti.y = 11;
    iti2.x = 4;
    iti2.y = 11;
    display_line(color, iti, iti2);

    iti.x = 4;
    iti.y = 11;
    iti2.x = 4;
    iti2.y = 4;
    display_line(color, iti, iti2);

    // 0ji
    iti.x = 4;
    iti.y = 4;
    color.r = Z_colorMax;
    color.g = Z_colorMin;
    display_pset(color, iti);

    // 1ji
    iti.x = 6;
    iti.y = 4;
    color.r = Z_colorMax;
    color.g = Z_colorMax;
    display_pset(color, iti);

    // 2ji
    iti.x = 9;
    iti.y = 4;
    color.r = Z_colorMax;
    color.g = Z_colorMax;
    display_pset(color, iti);

    // 3ji
    iti.x = 11;
    iti.y = 4;
    color.r = Z_colorMax;
    color.g = Z_colorMin;
    display_pset(color, iti);

    // 4ji
    iti.x = 11;
    iti.y = 6;
    color.r = Z_colorMax;
    color.g = Z_colorMax;
    display_pset(color, iti);

    // 5ji
    iti.x = 11;
    iti.y = 9;
    color.r = Z_colorMax;
    color.g = Z_colorMax;
    display_pset(color, iti);

    // 6ji
    iti.x = 11;
    iti.y = 11;
    color.r = Z_colorMax;
    color.g = Z_colorMin;
    display_pset(color, iti);

    // 7ji
    iti.x = 9;
    iti.y = 11;
    color.r = Z_colorMax;
    color.g = Z_colorMax;
    display_pset(color, iti);

    // 8ji
    iti.x = 6;
    iti.y = 11;
    color.r = Z_colorMax;
    color.g = Z_colorMax;
    display_pset(color, iti);

    // 9ji
    iti.x = 4;
    iti.y = 11;
    color.r = Z_colorMax;
    color.g = Z_colorMin;
    display_pset(color, iti);

    // 10ji
    iti.x = 4;
    iti.y = 9;
    color.r = Z_colorMax;
    color.g = Z_colorMax;
    display_pset(color, iti);

    // 12ji
    iti.x = 4;
    iti.y = 6;
    color.r = Z_colorMax;
    color.g = Z_colorMax;
    display_pset(color, iti);

}

/******************************************************************************
Name       : byo iti zahyo no sansyutu
Parameters : none
Returns    : nothing
Description: 
******************************************************************************/
static _DISPLAYPOSITION tokei_byoIti(uint8_t sec)
{
    _DISPLAYPOSITION iti;

    // genzai no byo iti wo 100ms goto ni 1dankai zutu tento
    if(sec <= 14){
        iti.x = sec;
        iti.y = 0;
    }
    else if(sec <= 29){
        iti.x = 15;
        iti.y = sec % 15;
    }
    else if(sec <= 44){
        iti.x = 15 - (sec % 15);
        iti.y = 15;
    }
    else{
        iti.x = 0;
        iti.y = 15 - (sec % 15);
    }
    return iti;
}

/******************************************************************************
Name       : ji iti zahyo no sansyutu
Parameters : ji : 0 - 11, min : 0 - 59
Returns    : nothing
Description: 
******************************************************************************/
static _DISPLAYPOSITION tokei_jiIti(uint8_t ji, uint8_t min)
{
    uint8_t jiIti;
    _DISPLAYPOSITION iti;
    // genzai no ji iti wo tento
    jiIti = (ji * 3) + (min / 20);
    if(jiIti <= 8){
        iti.x = jiIti + 3;
        iti.y = 3;
    }
    else if(jiIti <= 17){
        iti.x = 12;
        iti.y = (jiIti % 9) + 3;
    }
    else if(jiIti <= 26){
        iti.x = 12 - (jiIti % 9) ;
        iti.y = 12;
    }
    else{
        iti.x = 3;
        iti.y = 12 - (jiIti % 9);
    }
    
    return iti;

}