/***********************************************************************/
/*                                                                     */
/*    display.c                                                          */
/*                                                                     */
/***********************************************************************/
#define _DISPLAY_C

#include "display.h"

/*****************************Macro definition********************************/

/*****************************Global variable*********************************/

/******************************Function declaration***************************/
static bool_t display_positionCheck(_DISPLAYPOSITION *c);
static bool_t display_colorCheck(_DISPLAYCOLOR *c);

/******************************************************************************
Name       : hyoji zahyo no hani check
Parameters : none
Returns    : nothing
Description: D_display[][][] = 0x00
******************************************************************************/
static bool_t display_positionCheck(_DISPLAYPOSITION *p)
{
    bool_t ans = TRUE;

    if((*p).x < Z_displayXMin){ans = FALSE;}
    if((*p).x > Z_displayXMax){ans = FALSE;}
    
    if((*p).y < Z_displayXMin){ans = FALSE;}
    if((*p).y > Z_displayXMax){ans = FALSE;}

    return ans;
}
/******************************************************************************
Name       : hyoji color no hani check
Parameters : none
Returns    : nothing
Description: D_display[][][] = 0x00
******************************************************************************/
static bool_t display_colorCheck(_DISPLAYCOLOR *c)
{
    bool_t ans = TRUE;

    if((*c).g < Z_colorMin){ans = FALSE;}
    if((*c).g > Z_colorNull){ans = FALSE;}
    
    if((*c).r < Z_colorMin){ans = FALSE;}
    if((*c).r > Z_colorNull){ans = FALSE;}

    return ans;
}

/******************************************************************************
Name       : display_clr()
Parameters : none
Returns    : nothing
Description: D_display[][][] = 0x00
******************************************************************************/
void display_clr(void)
{
    uint8_t x,y;

    for(x = 0; x <= Z_displayXMax; x++){
        for(y = 0; y <= Z_displayYMax; y++){
            D_display[Z_red][x][y] = 0;
            D_display[Z_green][x][y] = 0;
        }
    }
}

/******************************************************************************
Name       : display_pset(redGradiation,greenGradiation,x,y)
Parameters : color   x    y
Returns    : nothing
Description: 
******************************************************************************/
void display_pset(_DISPLAYCOLOR c, _DISPLAYPOSITION p)
{
    if(( display_positionCheck(&p) == TRUE) 
    && ( display_colorCheck(&c) == TRUE)
    ){
        if(c.r < Z_colorNull){
            D_display[Z_red][p.x][p.y] = c.r;
        }
        if(c.g < Z_colorNull){
            D_display[Z_green][p.x][p.y] = c.g;
        }
    }
}

/******************************************************************************
Name       : display_pset(redGradiation,greenGradiation,x,y)
Parameters : color   x    y
Returns    : nothing
Description: 
******************************************************************************/
void display_line(_DISPLAYCOLOR c, _DISPLAYPOSITION p0, _DISPLAYPOSITION p1)
{
    _DISPLAYPOSITION d;    // henka ryo
    _DISPLAYPOSITION s; // hoko

    uint8_t i;
    int16_t E;

    d.x = (p1.x > p0.x) ? p1.x - p0.x : p0.x - p1.x;
    d.y = (p1.y > p0.y) ? p1.y - p0.y : p0.y - p1.y;

    s.x = (p1.x > p0.x) ? 1 : -1;
    s.y = (p1.y > p0.y) ? 1 : -1;

    /* katamuki ga 1 yori chiisai baai */
  if ( d.x > d.y ) {
    E = -d.x;
    for ( i = 0 ; i <= d.x ; i++ ) {
      display_pset( c, p0 );
      p0.x += s.x;
      E += 2 * d.y;
      if ( E >= 0 ) {
        p0.y += s.y;
        E -= 2 * d.x;
      }
    }
  /* katamuki ga 1 ijo no baai */
      } else {
        E = -d.y;
        for ( i = 0 ; i <= d.y ; i++ ) {
            display_pset( c, p0 );
            p0.y += s.y;
            E += 2 * d.x;
              if ( E >= 0 ) {
                p0.x += s.x;
                E -= 2 * d.y;
              }
        }
    }

}


/******************************************************************************
Name       : display_pset(redGradiation,greenGradiation,x,y)
Parameters : color   x    y        l:genten kara no dot suu
Returns    : nothing
Description: 
******************************************************************************/
void display_lineLimit(_DISPLAYCOLOR c, _DISPLAYPOSITION p0, _DISPLAYPOSITION p1, uint8_t l)
{
    _DISPLAYPOSITION d;    // henka ryo
    _DISPLAYPOSITION s; // hoko

    uint8_t i;
    int16_t E;

    d.x = (p1.x > p0.x) ? p1.x - p0.x : p0.x - p1.x;
    d.y = (p1.y > p0.y) ? p1.y - p0.y : p0.y - p1.y;

    s.x = (p1.x > p0.x) ? 1 : -1;
    s.y = (p1.y > p0.y) ? 1 : -1;

    /* katamuki ga 1 yori tiisai baai */
  if ( d.x > d.y ) {
    E = -d.x;
    if(d.x > (l - 1)){d.x = (l - 1);}
    for ( i = 0 ; i <= d.x ; i++ ) {
      display_pset( c, p0 );
      p0.x += s.x;
      E += 2 * d.y;
      if ( E >= 0 ) {
        p0.y += s.y;
        E -= 2 * d.x;
      }
    }
  /* katamuki ga 1 ijo no baai */
      } else {
        E = -d.y;
        if(d.y > (l - 1)){d.y = (l - 1);}
        for ( i = 0 ; i <= d.y ; i++ ) {
            display_pset( c, p0 );
            p0.y += s.y;
            E += 2 * d.x;
              if ( E >= 0 ) {
                p0.x += s.x;
                E -= 2 * d.y;
              }
        }
    }

}



















/******************************************************************************
Name       : display_test()
Parameters : none
Returns    : nothing
Description: 
******************************************************************************/
void display_test0(void)
{
    _DISPLAYCOLOR c = {15, 15};
    _DISPLAYPOSITION p0 ={1, 1};
    static _DISPLAYPOSITION p1 ={0, 15};
    display_line(c, p0, p1);

    if(++p1.x > Z_displayXMax){p1.x = Z_displayXMin;}

}


/******************************************************************************
Name       : display_test()
Parameters : none
Returns    : nothing
Description: 
******************************************************************************/
void display_test(void)
{
    uint8_t x,y;
    
    


    for(x = 0; x < 16; x++){
        for(y = 0; y < 16; y++){
            D_display[Z_red][x][y] = y;
        }
    }
    for(y = 0; y < 16; y++){
        for(x = 0; x < 16; x++){
            D_display[Z_green][x][y] = x;
        }
    }
}
/******************************************************************************
Name       : display_test2()
Parameters : none
Returns    : nothing
Description: 
******************************************************************************/
void display_test2(void)
{
    uint8_t x,y;
    static uint8_t c = 0;
    static int8_t s= 1;
    
    c += s;
    if(c > 15){
        c = 15;
        s = -1;
    }
    else if (c == 0){
        s = 1;
    }
    
    for(x = 0; x < 16; x++){
        for(y = 0; y < 16; y++){
//            if(++D_display[Z_red][x][y] > 15){D_display[Z_red][x][y] = 0;}
            D_display[Z_green][x][y] = c;
//            if(++D_display[Z_green][x][y] > 15){D_display[Z_green][x][y] = 0;}
        }
    }

}


