/***********************************************************************/
/*                                                                     */
/*    NTP.c                                                            */
/*                                                                     */
/***********************************************************************/
#define _NTP_C

#include "mbed.h"
#include "NTPClient.h"
#include "EthernetNetIf.h"
#include "NTP.h"

EthernetNetIf eth; 
NTPClient ntp;

/******************************************************************************
Name       : Ethernet no initialize
Parameters : none
Returns    : -1:NG 0:OK
Description: -
******************************************************************************/
int8_t ntp_ethernetInitial(void){

  printf("Start\n");
  printf("Setting up...\n");
  
 
    EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    return 0;
}

/******************************************************************************
Name       : Ethernet no initialize
Parameters : none
Returns    : -1:NG 0:OK
Description: -
******************************************************************************/
void ntp_ntpDataGet(void){
  time_t ctTime;
  ctTime = time(NULL);  
  printf("Current time is (UTC): %s\n", ctime(&ctTime));  

    Host server(IpAddr(), 123, "ntp.nict.jp");
//  Host server(IpAddr(), 123, "ntp1.jst.mfeed.ad.jp" );
//  Host server(IpAddr(), 123, "0.uk.pool.ntp.org");
  
  ntp.setTime(server);
    
  ctTime = time(NULL);  
  printf("\nTime is now (UTC): %s\n", ctime(&ctTime)); 
}


