/*****************************************************
* dot matrix led drive
*
*       Display : LT5016M1(16*16 dot matrix LED red&green led) http://akizukidenshi.com/catalog/g/gI-00039/
*       LED Driver : TLC5940  http://focus.ti.com/lit/ds/slvs515c/slvs515c.pdf
*
* V0.0 : 110529A_dotMatrixClock.zip
* V0.1 : 110601A_demo.zip
*           fuyo code sakujo (dosa ha V0.0 to onazi)                   
*****************************************************/
#define _DOTMATRIX_C

#define DBG

#include "Types.h"
#include "mbed.h"
#include "dotmatrix.h"
#include "display.h"
#ifdef DBG
#include "TLC5940.h"
#endif //DBG

static uint16_t DT_grayData[100]; //100kaicho data wo TLC5940 no grayData(4096kaicho)ni henkan suru data table

/******************************Function declaration***************************/
#ifndef DBG
static void tlc5940DotCorrection(void);
static void tlc5940SpiInitalize(void);
static void tlc5940GrayDataClear(void);
#endif //DBG
static void tlc5940GrayDataDisplayAndSend(int8_t rowNo);
static void dotmatrix_displayDataTransform(void);

/*****************************Macro definition********************************/
#ifdef DBG
    TLC5940 tlc5940(p5, p6, p7, p19, p22, p21, 2);
#else //~DBG
// TLC5940 control
SPI spi(p5, p6, p7);    //SIN (p6), SCLK,GSCLK(p7)

DigitalOut XLAT(p19);
DigitalOut BLANK(p22);
DigitalOut VPRG(p21);
#endif  // DBG

// TD62783APG  (dot matrix ROW1 - ROW16 drive)
DigitalOut ROW1(p16);
DigitalOut ROW2(p15);
DigitalOut ROW3(p14);
DigitalOut ROW4(p13);
DigitalOut ROW5(p12);
DigitalOut ROW6(p11);
DigitalOut ROW7(p10);
DigitalOut ROW8(p9);

DigitalOut ROW9(p23);
DigitalOut ROW10(p24);
DigitalOut ROW11(p25);
DigitalOut ROW12(p26);
DigitalOut ROW13(p27);
DigitalOut ROW14(p28);
DigitalOut ROW15(p29);
DigitalOut ROW16(p30);

#define Z_ROWMIN (0)
#define Z_ROWMAX (15)    // ROW Max (ROWNo = 0 to 15)

/*****************************Global variable*********************************/
// dot matrix led grayscale data
uint16_t D_dotDisplay[2][16][16];
/*
[color][x][y]:
color 0:red data    1:green data
x : 0 - 15
y : 0 - 15

data : 0 - 4095
*/





/******************************************************************************
Name       : dot matrix output
Parameters : none
Returns    : nothing
Description: extren call
******************************************************************************/
void dotmatrix_output(void) {
    static int8_t cnt = Z_ROWMAX;



    if (++cnt > Z_ROWMAX) {
        F_kakikae = 1;
        cnt = Z_ROWMIN;
         dotmatrix_displayDataTransform();    // hyoji data henkan
        F_kakikae = 0;
    }

    // ROW All Off
    ROW1 = 0;
    ROW2 = 0;
    ROW3 = 0;
    ROW4 = 0;
    ROW5 = 0;
    ROW6 = 0;
    ROW7 = 0;
    ROW8 = 0;
    ROW9 = 0;
    ROW10 = 0;
    ROW11 = 0;
    ROW12 = 0;
    ROW13 = 0;
    ROW14 = 0;
    ROW15 = 0;
    ROW16 = 0;
    
 


    // ROW out
    switch (cnt) {
        case 0:
            ROW1 = 1;
            break;
        case 1:
            ROW2 = 1;
            break;
        case 2:
            ROW3 = 1;
            break;
        case 3:
            ROW4 = 1;
            break;
        case 4:
            ROW5 = 1;
            break;
        case 5:
            ROW6 = 1;
            break;
        case 6:
            ROW7 = 1;
            break;
        case 7:
            ROW8 = 1;
            break;
        case 8:
            ROW9 = 1;
            break;
        case 9:
            ROW10 = 1;
            break;
        case 10:
            ROW11 = 1;
            break;
        case 11:
            ROW12 = 1;
            break;
        case 12:
            ROW13 = 1;
            break;
        case 13:
            ROW14 = 1;
            break;
        case 14:
            ROW15 = 1;
            break;
        case 15:
            ROW16 = 1;
            break;
         default:
            cnt = 0;
            break;
    }

  // display data set
  // ROW = Hi no atoni Column output
    tlc5940GrayDataDisplayAndSend(cnt);

}

/******************************************************************************
Name       : TLC5940 initalize
Parameters : none
Returns    : nothing
Description: extren call
******************************************************************************/
void dotmatrix_initialize(void){
#ifndef DBG
    tlc5940DotCorrection();
    tlc5940SpiInitalize();
    tlc5940GrayDataClear();
#endif // DBG
}

/******************************************************************************
Name       : Display data set demo initialize
Parameters : none
Returns    : nothing
Description: extren call
******************************************************************************/
void dotmatrix_demoInitialize(void) {
    for(int8_t y = 0; y < 16; y++){
        for(int8_t x = 0; x < 16; x++){
            D_dotDisplay[0][x][y] = (4095 * x) / 15;
            D_dotDisplay[1][x][y] = (4095 * y) / 15;
        }
    }
}
/******************************************************************************
Name       : Display data set demo
Parameters : none
Returns    : nothing
Description: extren call
******************************************************************************/
void dotmatrix_demo(void) {

    static int8_t x = 0;
    static int8_t y = 0;
    
     for(x = 0; x < 16; x++){
        for(y = 0; y < 16; y++){
            D_dotDisplay[0][x][y] += 3;
            D_dotDisplay[1][x][y] += 3;
        }
    }
}

#ifndef DBG
/******************************************************************************
Name       : TLC5940 dot correction initalize
Parameters : none
Returns    : nothing
Description: 
******************************************************************************/
static void tlc5940DotCorrection(void) {
    VPRG = 1;
    spi.format(6,0);
    spi.frequency(30000000);


//    VPRG = 1;

    for (int i = 0; i < (16 * 2); i++) {
        int whoami = spi.write(63);
    }

    XLAT = 1;
    XLAT = 0;
}
#endif //DBG

#ifndef DBG
/******************************************************************************
Name       : SPI Initalize (for TLC5960 control)
Parameters : none
Returns    : nothing
Description: 
******************************************************************************/
static void tlc5940SpiInitalize(void) {
    spi.format(12,0);
    spi.frequency(30000000);

    VPRG = 0;
}
#endif //DBG

#ifndef DBG
/******************************************************************************
Name       : TLC5940 Gray Data clear
Parameters : none
Returns    : nothing
Description: 
******************************************************************************/
static void tlc5940GrayDataClear(void) {

    VPRG = 0;
    
    for (int i = 0; i < (16 * 2); i++) {
        int whoami = spi.write(0);
    }

    XLAT = 1;
    XLAT = 0;
}
#endif //DBG

/******************************************************************************
Name       : TLC5940 Gray Data Display & next data send
Parameters : rowNo 0 - 15
Returns    : nothing
Description: 
******************************************************************************/
#ifdef DBG
static void tlc5940GrayDataDisplayAndSend(int8_t rowNo){

    uint8_t x;
    int8_t sendRowNo = rowNo + 1;
    uint16_t D_gray[2][16];
    
    if(sendRowNo > 15){sendRowNo = 0;}
    // green data send
    for(x = 0; x < 16; x++){
        D_gray[1][x] = D_dotDisplay[1][x][sendRowNo];
    }
    // red data send
    for(x = 0; x < 16; x++){
        D_gray[0][x] = D_dotDisplay[0][15 - x][sendRowNo];
    }

    tlc5940.grayDataSetAndDisplay((uint16_t*)D_gray);
    
}    
#else //~DBG
static void tlc5940GrayDataDisplayAndSend(int8_t rowNo){

    int8_t sendRowNo = rowNo + 1;

    int8_t x; // display data no x    0 - 15

    #define Z_GSCLKNUM (340)    // GRAYSCALE PWM sousin yo clock  4096(PWM) / 12bit(sousin) = 341
    #define Z_GRAYDATA (16 * 2)
    
    
    BLANK = 1;
    BLANK = 0;


  
    
    VPRG = 0;

    if(sendRowNo > 15){sendRowNo = 0;}

    for(int i = 0; i < (Z_GSCLKNUM - Z_GRAYDATA); i++){
        // grayscale pwm clock only
        spi.write(0);
    }
    
    // grayscale pwm clock & color data clock
    // green data send
    for(x = 0; x < 16; x++){
        spi.write(D_dotDisplay[1][15 - x][sendRowNo]);
    }
    // red data send
    for(x = 0; x < 16; x++){
        spi.write(D_dotDisplay[0][x][sendRowNo]);
    }
   
    XLAT = 1;
    XLAT = 0;
}
#endif //DBG


/******************************************************************************
Name       : display data kaicho wo TLC5940 Gray Data ni henkan suru data table ti no sakusei
Parameters : none 
Returns    : nothing
Description: 
******************************************************************************/
void dotmatrix_grayDataKansan(void){

    for(uint32_t i = 0; i < 100; i++){
         DT_grayData[i] = (uint16_t)((i * i * 10) / 40);
    }
}

/******************************************************************************
Name       : display data transform to TLC5940 Gray Data
Parameters : none 
Returns    : nothing
Description: 
******************************************************************************/
static void dotmatrix_displayDataTransform(void){
 
    // D_display[][][] no 15grayScaleData wo 4096grayScale Data ni henkan
    for(uint8_t x = 0; x < 16; x++){
        for(uint8_t y = 0; y < 16; y++){
        D_dotDisplay[Z_dotGreen][x][y]     = DT_grayData[B_display[Z_green][x][y]];
        D_dotDisplay[  Z_dotRed][x][y]     = DT_grayData[B_display[  Z_red][x][y]];
        }
    }
}
