/*****************************************************
* dot matrix clock
*
*       Display : LT5016M1(16*16 dot matrix LED red&green led) http://akizukidenshi.com/catalog/g/gI-00039/
*       LED Driver : TLC5940  http://focus.ti.com/lit/ds/slvs515c/slvs515c.pdf
*
* V0.0 : 110621A_110621dotMatrixClock.zip
*        sample program                    
*****************************************************/
#include "mbed.h"
#include "dotmatrix.h"
#include "tokei.h"
#include "NTP.h"

Timer timer;

/************************************
* main
************************************/
int main() {

    uint32_t tstart;
    uint32_t tend;
    
    // Ethernet initial
    int8_t ether = ntp_ethernetInitial();
    if(ether == -1){
        return(-1);
    }
    
    // first ntp data get
    ntp_ntpDataGet();

//demo (UTC + 15houre(nippon jikan hosei)
//        ji            fun        byo  hosei
//set_time((11 * 3600) + (59 * 60) + 55 + 54000); 


    // hyoji data sakusei timming yo timer
    timer.start();
    tstart = timer.read_ms();

    dotmatrix_initialize();
    dotmatrix_grayDataKansan();


    while (1) {

        // 10ms keika sitara hyoji data wo sakusei        
        tend = timer.read_ms();
        if((tend - tstart) >= 10){
            tstart = tend;
            tokei_main();
       }

        dotmatrix_output();
   }

}
