/***********************************************************************/
/*                                                                     */
/*    display.h                                                          */
/*                                                                     */
/***********************************************************************/
#ifndef _DISPLAY_H
#define _DISPLAY_H

#include "Types.h"

/*****************************Macro definition********************************/
#define Z_colorNo (2)
#define Z_red   (0)
#define Z_green (1)

#define Z_colorMin (0)
#define Z_colorMax (99)
#define Z_colorNull (100)

#define Z_displayXMin    (0)
#define Z_displayYMin    (0)
#define Z_displayXMax    (15)
#define Z_displayYMax    (15)

typedef struct{
    int16_t x;
    int16_t y;
}_DISPLAYPOSITION;

typedef struct{
    int16_t r;        // red color data
    int16_t g;        // green color data
}_DISPLAYCOLOR;

/******************************Function declaration***************************/
void display_clr(void);
void display_test0(void);
void display_test(void);
void display_test2(void);

void display_pset(_DISPLAYCOLOR c, _DISPLAYPOSITION p);
void display_line(_DISPLAYCOLOR c, _DISPLAYPOSITION p0, _DISPLAYPOSITION p1);
void display_lineLimit(_DISPLAYCOLOR c, _DISPLAYPOSITION p0, _DISPLAYPOSITION p1, uint8_t l);


/*****************************Global variable*********************************/
#ifdef _DISPLAY_C
    #define    EXTERN
    #define    GLOBAL_VARIABLE_DEFINE
#else
    #define    EXTERN extern
#endif

// hyoji data sakusei yo
EXTERN uint8_t D_display[Z_colorNo][Z_displayXMax + 1][Z_displayYMax + 1];
    // [Color][Horizontal][Vertical]
    // [Color] Z_green (0)    Z_red(1)
    // 
    // Horizontal : X        Vertical : Y
    // [X][Y]       X00,X01,-X14,X15
    //            Y00
    //            Y01
    //            |
    //            Y14
    //            Y15
    // 
    //             byte data no imi
    //             0:off    1:min - 15:max
    // 

// hyoji data kakutei yo
EXTERN uint8_t B_display[Z_colorNo][Z_displayXMax + 1][Z_displayYMax + 1];

#undef    _DISPLAY_C
#undef    EXTERN
#undef    GLOBAL_VARIABLE_DEFINE

#endif    // _DISPLAY_H
