#include "mbed.h"
#include "ACM1602NI.h"  //https://developer.mbed.org/users/takuo/code/ACM1602NI/docs/661827681a12/classACM1602NI.html
#include "DigitalSw.h"
#include "si5351a.h"    //https://developer.mbed.org/users/kenjiArai/code/Si5351A/file/af2d99cfb3f0/si5351a.cpp

//#define LPC1114
/*
#ifdef LPC1114
I2C i2c(dp5, dp27);  // sda, scl
#else
I2C i2c(p9, p10);
#endif
*/

 // I2C pins: p9 = sda, p10 = scl
ACM1602NI lcd(p9, p10);   // (sda, scl)
// ACM1602NI lcd(p28, p27);   // (sda, scl)

// Vout mesure
AnalogIn Vout(p20);

//**************************************************************
// Si5351a
SI5351A clk(p28, p27, 25000000UL);     // Base clock = 25MHz
 
 // Digital Sw
#ifdef LPC1114
 DigitalSw upSw(dp18);
 DigitalSw downSw(dp17);
 DigitalSw startSw(dp16);
#else
 DigitalSw upSw(p18);
 DigitalSw downSw(p17);
 DigitalSw startSw(p15);
#endif 

 int16_t frequency = 1;
 
DigitalOut myled(LED1);

void swProcess(void)
{
        if(upSw.getOnEdge() == 1){
           if(frequency < 50){frequency++;}
            clk.set_frequency(SI5351_CLK0, frequency * 1000000);    

           }

        if(downSw.getOnEdge() == 1){
           if(frequency > 1){frequency--;}
            clk.set_frequency(SI5351_CLK0, frequency * 1000000);    
           }
           
        if(startSw.getOnEdge() == 1){
           frequency = 25;
            clk.set_frequency(SI5351_CLK0, frequency * 1000000);    
           }

}


int main() {
            clk.set_frequency(SI5351_CLK0, frequency * 1000000);    

    while(1) {

    swProcess();

             lcd.printf("Vout = %3.2f [V]\n", Vout * 3.3);
     lcd.printf("%2d [MHz]\n",frequency);
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
