//==========================================================
//
//   TLC5940.cpp
//   TLC5940(Texas Instruments  16 channel led driver with dot correction and grayscale pwm control)
//            http://datasheet.octopart.com/TLC5940NT-Texas-Instruments-datasheet-121738.pdf
//==========================================================
#define _TLC5940_C

#include "types.h"
#include "mbed.h"
#include "TLC5940.h"




/** DC motor direct drive object connected to the specified DigtalOutput pin
 */
TLC5940::TLC5940(PinName mosi, PinName miso, PinName sck, PinName xlat, PinName blank, PinName vprg, uint8_t cascade) :
 _spi(mosi, miso, sck), _xlat(xlat), _blank(blank), _vprg(vprg){
 
    _xlat = 0;
    _blank = 0;
    _vprg = 0;
 
    D_cascade = cascade;
 
    tlc5940DotCorrection();
    tlc5940SpiInitalize();
    tlc5940GrayDataClear();   
}

/******************************************************************************
Name       : TLC5940 dot correction initalize
Parameters : none
Returns    : nothing
Description: 
******************************************************************************/
void TLC5940::tlc5940DotCorrection(void) {
    _vprg = 1;
    _spi.format(6,0);
    _spi.frequency(Z_clockFrequency);


//    _vprg = 1;

    for (int i = 0; i < (16 * D_cascade); i++) {
        int whoami = _spi.write(Z_dotCorrection);
    }

    _xlat = 1;
    _xlat = 0;
}

/******************************************************************************
Name       : SPI Initalize (for TLC5960 control)
Parameters : none
Returns    : nothing
Description: 
******************************************************************************/
void TLC5940::tlc5940SpiInitalize(void) {
    _spi.format(12,0);
    _spi.frequency(Z_clockFrequency);

    _vprg = 0;
}    

/******************************************************************************
Name       : TLC5940 Gray Data clear
Parameters : none
Returns    : nothing
Description: 
******************************************************************************/
void TLC5940::tlc5940GrayDataClear(void) {

    _vprg = 0;
    
    for (int i = 0; i < (16 * D_cascade); i++) {
        int whoami = _spi.write(0);
    }

    _xlat = 1;
    _xlat = 0;
}

/**************************************
* main
**************************************/
void TLC5940::grayDataSetAndDisplay(uint16_t *data) {

// *data = &D_grayScale[][]
  //  D_grayScale[cascade][16]; // [][0] = out0, [][1] = out1, ... ,[][14] = out15
                              // [x][x].11,[x][x].10, ... ,[x][x].1,[x][x].0 = (xxxx xxxx xxxxb)  1gray scale data

//         [0][0]  [0][1]  [0][14]   [0][15]            [1][0]  [1][1]  [1][14]   [1][15]                      [20][0] 20][1] [20][14]   [20][15]   
//           |     |  ...   |         |                    |     |  ...  |           |                           |     |  ...  |           |   
//      ----------------------------------|           ------------------------------------|                 ------------------------------------|
//      | out0     1  ...   14        15  |-----------| out0     1  ...  14          15   |-----......------| out0     1  ...  14          15   |
//      |TLC5940  (cascade = 1)           |           |TLC5940  (cascade = 2)             |                 |TLC5940  (cascade = 21)            | 
//      -----------------------------------           -------------------------------------                 -------------------------------------
//


   int8_t x; // display data no x    0 - 15

    #define Z_GSCLKNUM (340)    // GRAYSCALE PWM sousin yo clock  4096(PWM) / 12bit(sousin) = 341
    #define Z_GRAYDATA (16 * D_cascade)
    
    
    _blank = 1;
    _blank = 0;


  
    
    _vprg = 0;

    for(int i = 0; i < (Z_GSCLKNUM - Z_GRAYDATA); i++){
        // grayscale pwm clock only
        _spi.write(0);
    }
    
    // grayscale pwm clock & color data clock
    // green data send
    for(uint8_t C_cascade = 1; C_cascade <= D_cascade; C_cascade++){
        for(x = 0; x < 16; x++){
            _spi.write((uint16_t)*(data + (16 * (D_cascade - C_cascade)) + (15 - x)));
        }
    }
    
   
    _xlat = 1;
    _xlat = 0;

}


