/* mbed TLC5940 Library
 * Copyright (c) 2011 suupen
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


//================================
//    TLC5940.h        
// V1.0 : 2011/xx/xx                       
//                               
//================================
#ifndef _TLC5940_H
#define _TLC5940_H

/** TLC5940 class
 *
 * Example:
 * @code
 * comming soon
 * @endcode
 */



#include "types.h"

class TLC5940 {
public:
    
    /** Create a eight dot matrix led array object connected to the specified DigitalOut pin
    * @param mosi,misc,sck = SPI(p5,p6,p7) or SPI(p11,p12,p13)
    * @param digitalOut xlat
    * @param digitalOut blank
    * @param digitalOut vprg 
    * @param uint8_t cascade  cascade number = 1 - 21   
    */

    TLC5940(PinName mosi, PinName miso, PinName sck, PinName xlat, PinName blank, PinName vprg, uint8_t cascade = 1);
    
    
    /** Data set to the seven segment LED display
    * @param uint16_t* data : grayData table  &data[cascade number][16]  data[][] = 11 - 0bit
    */
    void grayDataSetAndDisplay(uint16_t *data);

private:

    SPI _spi;
    DigitalOut _xlat;
    DigitalOut _blank;
    DigitalOut _vprg;

    #define Z_clockFrequency (30000000) // Data shift clock frequency and Grayscale clock frequency = 30[MHz]
    #define Z_dotCorrection (63)    // 5 - 0 bit = (11 1111)b = 63d
    uint8_t D_cascade; // cascade number 1 - 21
    #define Z_cascadeMax (21)   //cascade number max (21)

    void tlc5940DotCorrection(void);
    void tlc5940SpiInitalize(void);
    void tlc5940GrayDataClear(void);
    
    
};

#endif    // _TLC5940_H
