/**
 * Swift Propo Decode test program 
 *   130623
 *
 * Writer:suupen
 *
 *  <circuit diagram>
 *      VU(mbed)
 *         |
 *         |Vcc
 *        ---    (PL-IRM2161) IR Reciver
 *       |   |Vout
 *       |   |--- p5(mbed)
 *       |   |
 *        ---
 *         |GND
 *         |
 *       GND(mbed)
 *
 *  <PC termnal soft>
 *   tera term
 *      baudrate:38400[bps]
 *      data:8[bit]
 *      parity:none
 *      stopbit:1[bit]
 */
 
#define PROPO_RAW_DATA        // ari: zyusin data hyoji   nasi:Swift kaiseki data hyoji
#define SWIFT_NORMALIZE     // ari: Swift data seikika hyoji  nasi: Swift data tujyo hyoji
 
 
#include "mbed.h"
#include "ReceiverIR.h"

#include "CodecSwift.h"
#include "DecodeSwift.h"


#define SWIFT_USE

void display_format(RemoteIR::Format format);
void display_binary(uint8_t *buf, uint8_t cnt);

Serial pc(USBTX,USBRX);


ReceiverIR ir_rx(p5);
RemoteIR::Format format;


#ifndef PROPO_RAW_DATA
DecodeSwift swift;
CodecSwift::swiftPropo_t swiftData;

#ifdef SWIFT_NORMALIZE
CodecSwift::normalizePropo_t normalize;
#endif // SWIFT_USE

#endif // PROPO_RAW_DATA

uint8_t buf[32];
int bitcount;

DigitalOut myled(LED1);
DigitalOut led2(LED2);
DigitalIn irtest(p20);


int main(){
    pc.baud(38400);
    while(1){

    myled =~myled;
    led2 = irtest;


 
 #ifdef PROPO_RAW_DATA
     if (ir_rx.getState() == ReceiverIR::Received) {
        bitcount = ir_rx.getData(&format, buf, sizeof(buf) * 8);
        
        display_format(format);
        display_binary(buf, ((bitcount + 7) / 8));
     }
    else{
#if 0
        switch(ir_rx.getState()){
        
        case ReceiverIR::Idle:
            printf("Idele\n");
            break;
        case ReceiverIR::Receiving:
            printf("Receiveing\n");
            break;
        case ReceiverIR::Received:
            printf("Received\n");
        break;
        }
#endif
    }
#endif // PROPO_RAW_DATA

#ifndef PROPO_RAW_DATA

     if (ir_rx.getState() == ReceiverIR::Received) {
        bitcount = ir_rx.getData(&format, buf, sizeof(buf) * 8);
#ifdef SWIFT_NORMALIZE
        bool ans = swift.normalize(buf, &normalize);
        if(ans == true){
            printf("count = %02x band = %1d  slottle = %f trim = %f ladder = %f elevator = %f\n",normalize.count,normalize.band,normalize.slottle,normalize.trim,normalize.ladder, normalize.elevator);
       }
        else{
            printf("NG\n");
        }        
#else // ~SWIFT_NORMALIZE
        bool ans = swift.decode(buf, &swiftData);
        if(ans == true){
            printf("count = %02x band = %02x  slottle = %03d trim = %03d ladder = %03d elevator = %03d\n",swiftData.count,swiftData.band,swiftData.slottle,swiftData.trim,swiftData.ladder, swiftData.elevator);
       }
        else{
            printf("NG\n");
        }
#endif
     }
#endif // SWIFT_NORMALIZE

    }
 
}

/**
 * Display a format of a data.
 */
void display_format(RemoteIR::Format format) {
    switch (format) {
        case RemoteIR::UNKNOWN:
            pc.printf("????????");
            break;
        case RemoteIR::NEC:
            pc.printf("NEC     ");
            break;
        case RemoteIR::NEC_REPEAT:
            pc.printf("NEC  (R)");
            break;
        case RemoteIR::AEHA:
            pc.printf("AEHA    ");
            break;
        case RemoteIR::AEHA_REPEAT:
            pc.printf("AEHA (R)");
            break;
        case RemoteIR::SONY: //HONEY_BEE:
            pc.printf("SONY or HONEY_BEE    ");
            break;
#ifdef SWIFT_PROTCOL
        case RemoteIR::SWIFT:
            pc.printf("SWIFT   ");
            break;
#endif // SWIFT_PROTCOL
        default:
            pc.printf("unknown  ");
            break;
    }
}

void display_binary(uint8_t *buf, uint8_t cnt){
    uint8_t i;
    uint8_t bitcnt;
    uint8_t dat;
    uint16_t checkbit;
    
    for(i = 0; i < cnt; i++){
        checkbit = 0x0080;
        dat = *(buf + i);
        printf("%02x:",dat);
        for(bitcnt = 0; bitcnt < 8; bitcnt++){
            if( checkbit & dat){printf("1");}
            else {printf("0");}
            
            checkbit = checkbit >> 1;
            if(bitcnt == 3){printf(" ");}
        }
        printf("  ");
    }
    printf("\n");
}


