//============================================
// SwDigital Library example program
// 
//  <schematic>
//
//  mbed
//                sw1
//                ---- 
//    p10 --------o  o----------- GND
//
//                sw2
//                ----
//    p20 --------o  o------------GND
//
//=============================================

#include "mbed.h"
#include "SwDigital.h"

SwDigital sw(p10,p20);  // p10 : sw1 control LED1,LED2
                        // p20 : sw2 control LED3,LED4
enum{
        sw1,
        sw2
    };

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

int main() {
    while(1) {
        //==============================================
        // sw1 - LED1,LED2 control
        //==============================================
        // sw level and edge data refresh
        sw.refreshEdgeData();
        
        // tact action (sw level = on : led1 = on)
        led1 = sw.checkLevel(sw1);
        
        // tact action (sw level = off : led2 = on)
        led2 = !sw.checkLevel(sw1);
        
        //==============================================
        // sw2 - LED3,LED4 control
        //==============================================
        // toggle action (level Off to On)
        if(sw.checkEdgeOn(sw2) == 1){
             led3 = !led3;
        }

        // toggle action (level On to Off)
        if(sw.checkEdgeOff(sw2) == 1){
             led4 = !led4;
        }
    }
}
