/* SwDigital Library
 * Copyright (c) 2011 suupen
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/***********************************************************************/
/*                                                                     */
/*    SwDigital.h                                                      */
/*                                                                     */
/*                                                                     */
/*    V0.1 : 2011/11/13                                                */
/*    @001 : 2011/12/11  example program bug fix                       */
/***********************************************************************/
#ifndef _SWDIGITAL_H
#define _SWDIGITAL_H

#include "mbed.h"

/** SWDIGITAL control class, based on a "mbed function"
*
* Example:
* @code
* //============================================
* // SwDigital Library example program
* // 
* //  <schematic>
* //
* //  mbed
* //                sw1
* //                ---- 
* //    p20 --------o  o----------- GND
* //
* //                sw2
* //                ----
* //    p21 --------o  o------------GND
* //
* //=============================================
*
*
* #include "mbed.h"
* #include "SwDigital.h"
*
* SwDigital sw(p20,p21);  // p20 : sw1 control LED1,LED2
*                        // p21 : sw2 control LED3,LED4
*
* DigitalOut led1(LED1);
* DigitalOut led2(LED2);
* DigitalOut led3(LED3);
* DigitalOut led4(LED4);
*
* int main() {
*    while(1) {
*        // sw level and edge data refresh
*        sw.refreshEdgeData();                          //@001
*        
*        // tact action (sw level = on : led1 = on)
*        led1 = sw.checkLevel(0);
*        
*        // tact action (sw level = off : led2 = on)
*        led2 = !sw.checkLevel(0);
*        
*        // toggle action (level Off to On)
*        if(sw.checkEdgeOn(1) == 1){
*             led3 = !led3;
*        }
*
*        // toggle action (level On to Off)
*        if(sw.checkEdgeOff(1) == 1){
*             led4 = !led4;
*        }
*    }
* }
*
* @endcode
*/

class SwDigital {
public:

    /** Create a sound object connected to the specified PwmOut pin & DigitalOut pin
    *
    * @param pin sw0 to sw19 : sw input pin 
    *
    * sw can be set from 1 to 20.
    * Recognition of the SW period is 10ms
    */
    SwDigital(PinName sw0  = NC, PinName sw1  = NC, PinName sw2  = NC, PinName sw3  = NC, PinName sw4  = NC,
              PinName sw5  = NC, PinName sw6  = NC, PinName sw7  = NC, PinName sw8  = NC, PinName sw9  = NC,
              PinName sw10 = NC, PinName sw11 = NC, PinName sw12 = NC, PinName sw13 = NC, PinName sw14 = NC,
              PinName sw15 = NC, PinName sw16 = NC, PinName sw17 = NC, PinName sw18 = NC, PinName sw19 = NC
              );

    /** refresh edge data
    *
    * @param none 
    * @param return none
    *
    *  main de edge data wo tukau maeni jiko suru
    */
    void refreshEdgeData(void);
    
    /** Check Off to On edge
    *
    * @param uint8_t swNo : check swNo 0 to 19 
    * @param return uint8_t  On edge check  0: edge Nasi  1: edge Ari
    *
    */
    uint8_t checkEdgeOn(uint8_t swNo);

    /** Check On to Off edge
    *
    * @param uint8_t swNo : check swNo 0 to 19 
    * @param return uint8_t Off edge check   0 : Nasi   1 : Ari
    *
    */
    uint8_t checkEdgeOff(uint8_t swNo);
    
    /** Check On to Off edge
    *
    * @param uint8_t swNo : check swNo 0 to 19 
    * @param return uint8_t sw level check   0 : Off   1 : On
    *
    */    
    uint8_t checkLevel(uint8_t swNo);
    
//protected:    
private:
   DigitalIn _sw0;
   DigitalIn _sw1;
   DigitalIn _sw2;
   DigitalIn _sw3;
   DigitalIn _sw4;

   DigitalIn _sw5;
   DigitalIn _sw6;
   DigitalIn _sw7;
   DigitalIn _sw8;
   DigitalIn _sw9;

   DigitalIn _sw10;
   DigitalIn _sw11;
   DigitalIn _sw12;
   DigitalIn _sw13;
   DigitalIn _sw14;

   DigitalIn _sw15;
   DigitalIn _sw16;
   DigitalIn _sw17;
   DigitalIn _sw18;
   DigitalIn _sw19;
   
   Ticker swCheckTimer;
   
   void input(void);

   #define Z_matchcycle (10000) // 10000[us](10[ms]) to 100000[us](100[ms])  1[us]/count
   
   uint8_t D_swSuu;         // touroku sareta Sw Suu  1 to 20
   #define Z_swSuuMax  (20)    // SW no saidai suu
   
   uint8_t B_kariLevel[Z_swSuuMax]; // kakutei mae no ninsiki Level 0bit:saisin(t) 1bit:t-1, ... ,7bit:t-7  0:Off  1:On
    // match number define
    //#define Z_itchiPattern     (0x03)   // 2kai itch
    #define Z_itchiPattern    (0x07)  // 3kai itchi
    //#define Z_itchiPattern    (0x0f)  // 4kai itchi
    //#define Z_itchiPattern    (0x1f)  // 5kai itchi
    //#define Z_itchiPattern    (0x3f)  // 6kai itchi
    //#define Z_itchiPattern    (0x7f)  // 7kai itchi
    //#define Z_itchiPattern    (0xff)  // 8kai itchi
   
   // sw level data
   uint8_t D_nowLevel[Z_swSuuMax];  // saisin no kakutei Level 0:Off  1:On
   uint8_t D_oldLevel[Z_swSuuMax];  // zenkai no kakutei Level 0:Off  1:On
    #define Z_levelOff (0)
    #define Z_levelOn (1)
   
   // sw edge data
   // swDigital.c naibu hensu 
   uint8_t B_edgeOn[Z_swSuuMax];    // off kara on  no ninsiki(on edge)  0:Nasi  1:Ari
   uint8_t B_edgeOff[Z_swSuuMax];   // on  kara off no ninsiki(off edge) 0:Nasi  1:Ari
   // user use hensu
   uint8_t D_edgeOn[Z_swSuuMax];    // off kara on  no ninsiki(on edge)  0:Nasi  1:Ari
   uint8_t D_edgeOff[Z_swSuuMax];   // on  kara off no ninsiki(off edge) 0:Nasi  1:Ari
    #define Z_edgeNasi (0)
    #define Z_edgeAri  (1)




};    

#endif    // _SWDIGITAL_H
