//======================================================================
//    SwDigital.cpp
//
// pwmOutput - digtalOutput de sound syuturyoku suru library
//======================================================================
#define _SWDIGITAL_C

#include "mbed.h"
#include "SwDigital.h"

//======================================================================
// syokika
//======================================================================

    SwDigital::SwDigital(PinName sw0, PinName sw1, PinName sw2, PinName sw3, PinName sw4,
                         PinName sw5, PinName sw6, PinName sw7, PinName sw8, PinName sw9,
                         PinName sw10, PinName sw11, PinName sw12, PinName sw13, PinName sw14,
                         PinName sw15, PinName sw16, PinName sw17, PinName sw18, PinName sw19
                         ):
                         _sw0(sw0),   _sw1(sw1),   _sw2(sw2),   _sw3(sw3),   _sw4(sw4),
                         _sw5(sw5),   _sw6(sw6),   _sw7(sw7),   _sw8(sw8),   _sw9(sw9),
                         _sw10(sw10), _sw11(sw11), _sw12(sw12), _sw13(sw13), _sw14(sw14),
                         _sw15(sw15), _sw16(sw16), _sw17(sw17), _sw18(sw18), _sw19(sw19)
                         {
       
    //---------------------------------
    // touroku sareta Sw Suu wo kakunin
    //---------------------------------
    if(sw0 != NC){D_swSuu = 1; _sw0.mode(PullUp);}
    if(sw1 != NC){D_swSuu = 2; _sw1.mode(PullUp);}
    if(sw2 != NC){D_swSuu = 3; _sw2.mode(PullUp);}
    if(sw3 != NC){D_swSuu = 4; _sw3.mode(PullUp);}
    if(sw4 != NC){D_swSuu = 5; _sw4.mode(PullUp);}
    
    if(sw5 != NC){D_swSuu = 6; _sw5.mode(PullUp);}
    if(sw6 != NC){D_swSuu = 7; _sw6.mode(PullUp);}
    if(sw7 != NC){D_swSuu = 8; _sw7.mode(PullUp);}
    if(sw8 != NC){D_swSuu = 9; _sw8.mode(PullUp);}
    if(sw9 != NC){D_swSuu = 10; _sw9.mode(PullUp);}    
    
    if(sw10 != NC){D_swSuu = 11; _sw10.mode(PullUp);}
    if(sw11 != NC){D_swSuu = 12; _sw11.mode(PullUp);}
    if(sw12 != NC){D_swSuu = 13; _sw12.mode(PullUp);}
    if(sw13 != NC){D_swSuu = 14; _sw13.mode(PullUp);}
    if(sw14 != NC){D_swSuu = 15; _sw14.mode(PullUp);}
    
    if(sw15 != NC){D_swSuu = 16; _sw15.mode(PullUp);}
    if(sw16 != NC){D_swSuu = 17; _sw16.mode(PullUp);}
    if(sw17 != NC){D_swSuu = 18; _sw17.mode(PullUp);}
    if(sw18 != NC){D_swSuu = 19; _sw18.mode(PullUp);}
    if(sw19 != NC){D_swSuu = 20; _sw19.mode(PullUp);}    
    
    // sw ninsiki syuki 10[ms]
    swCheckTimer.attach_us(this, &SwDigital::input, Z_matchcycle); 
        
}

void SwDigital::input(void){
    // genzai level input
    switch(D_swSuu){
    case 20:
        B_kariLevel[19] = ((B_kariLevel[19] << 1) | (((uint8_t)~_sw19) & 0x01));
        //break;
    case 19:
        B_kariLevel[18] = ((B_kariLevel[18] << 1) | (((uint8_t)~_sw18) & 0x01));
        //break;
    case 18:
        B_kariLevel[17] = ((B_kariLevel[17] << 1) | (((uint8_t)~_sw17) & 0x01));
        //break;        
    case 17:
        B_kariLevel[16] = ((B_kariLevel[16] << 1) | (((uint8_t)~_sw16) & 0x01));
        //break;        
    case 16:
        B_kariLevel[15] = ((B_kariLevel[15] << 1) | (((uint8_t)~_sw15) & 0x01));
        //break;       
    case 15:
        B_kariLevel[14] = ((B_kariLevel[14] << 1) | (((uint8_t)~_sw14) & 0x01));
        //break;
    case 14:
        B_kariLevel[13] = ((B_kariLevel[13] << 1) | (((uint8_t)~_sw13) & 0x01));
        //break;
    case 13:
        B_kariLevel[12] = ((B_kariLevel[12] << 1) | (((uint8_t)~_sw12) & 0x01));
        //break;        
    case 12:
        B_kariLevel[11] = ((B_kariLevel[11] << 1) | (((uint8_t)~_sw11) & 0x01));
        //break;        
     case 11:
        B_kariLevel[10] = ((B_kariLevel[10] << 1) | (((uint8_t)~_sw10) & 0x01));
        //break;               
        
    case 10:
        B_kariLevel[9] = ((B_kariLevel[9] << 1) | (((uint8_t)~_sw9) & 0x01));
        //break;
    case 9:
        B_kariLevel[8] = ((B_kariLevel[8] << 1) | (((uint8_t)~_sw8) & 0x01));
        //break;
    case 8:
        B_kariLevel[7] = ((B_kariLevel[7] << 1) | (((uint8_t)~_sw7) & 0x01));
        //break;        
    case 7:
        B_kariLevel[6] = ((B_kariLevel[6] << 1) | (((uint8_t)~_sw6) & 0x01));
        //break;        
    case 6:
        B_kariLevel[5] = ((B_kariLevel[5] << 1) | (((uint8_t)~_sw5) & 0x01));
        //break;       
    case 5:
        B_kariLevel[4] = ((B_kariLevel[4] << 1) | (((uint8_t)~_sw4) & 0x01));
        //break;
    case 4:
        B_kariLevel[3] = ((B_kariLevel[3] << 1) | (((uint8_t)~_sw3) & 0x01));
        //break;
    case 3:
        B_kariLevel[2] = ((B_kariLevel[2] << 1) | (((uint8_t)~_sw2) & 0x01));
        //break;        
    case 2:
        B_kariLevel[1] = ((B_kariLevel[1] << 1) | (((uint8_t)~_sw1) & 0x01));
        //break;        
    case 1:
        B_kariLevel[0] = ((B_kariLevel[0] << 1) | (((uint8_t)~_sw0) & 0x01));
        //break;                       
    default:
        // nothing
        break;
    }
    
    // kakutei Level kosin
    uint8_t kakutei = 0;
    for(uint8_t i = 0; i < D_swSuu; i++){
        uint8_t work = B_kariLevel[i] & Z_itchiPattern;
        if(work == 0x00){
            // off kakutei
            D_oldLevel[i] = D_nowLevel[i];
            D_nowLevel[i] = Z_levelOff;
            kakutei = 1;
        }
        else if(work == Z_itchiPattern){
            // on kakutei
            D_oldLevel[i] = D_nowLevel[i];
            D_nowLevel[i] = Z_levelOn;
            kakutei = 1;
        }
        else{
            // nothing
        }
        
        if(kakutei == 1){
            // edge kosin
            if((D_oldLevel[i] == Z_levelOff) && (D_nowLevel[i] == Z_levelOn)){
                B_edgeOn[i] = Z_edgeAri;
            }
            if((D_oldLevel[i] == Z_levelOn) && (D_nowLevel[i] == Z_levelOff)){
                B_edgeOff[i] = Z_edgeAri;
            }
        }

    }              
}

void SwDigital::refreshEdgeData(void){
    for(uint8_t i = 0; i < D_swSuu; i++){
        __disable_irq(); 	// Disable Interrupts
        D_edgeOn[i]  = B_edgeOn[i];
        D_edgeOff[i] = B_edgeOff[i];
        
        B_edgeOn[i]  = Z_edgeNasi;
        B_edgeOff[i] = Z_edgeNasi;
        __enable_irq(); 	// Enable Interrupts
    }
}

uint8_t SwDigital::checkEdgeOn(uint8_t swNo){
    uint8_t ans = 0;
    
    if(D_edgeOn[swNo] == Z_edgeAri){
        ans = 1;
    } 

    return (ans);
}

uint8_t SwDigital::checkEdgeOff(uint8_t swNo){
    uint8_t ans = 0;
    
    if(D_edgeOff[swNo] == Z_edgeAri){
        ans = 1;
    } 

    return (ans);
}

uint8_t SwDigital::checkLevel(uint8_t swNo){
    uint8_t ans = 0;
    
    if(D_nowLevel[swNo] == Z_levelOn){
        ans = 1;
    } 

    return (ans);
}
