// ********************************************************************
// SwAnalogInput Library example program
// Per pin analog port, SW recognition There are three possible.
//
// <schematic>
//   -.- mbed VOUT(+3.3[V])
//    |                                               |--------------------> mbed p20(ADinput)
//    |    8.2[kohm]       3.9[kohm]       2.0[kohm]  |    1.0[kohm]
//    |   ---------       ---------       ---------   |   ---------
//    .---| Rsw2  |---.---| Rsw1  |---.---| Rsw0  |---.---| Rout  |----|
//    |   ---------   |   ---------   |   ---------   |   ---------    |
//    |     ----      |     -----     |     -----     |                |
//    |-----o  o------.-----o  o------.-----o  o------|              -----
//           SW2            SW1              SW0                      mbed GND(0[V])
// 
//  
//  Accuracy of the resistance value that is within ± 1%
//
// <Operation details of this program>
//  mbed LED1 : When it detects the ON level of the SW0, and turns the LED1.
//  mbed LED2 : When it detects the OFF level of the SW1, and turns the LED2.
//  mbed LED3 : When it detects the ON edge of SW2, inverting the output to LED3.
//  mbed LED4 : When it detects the OFF edge of SW2, inverting the output to LED4.
//
// 
// <history>
// 120212 : first edtion
// 131221 : In this edition, I have changed the behavior of the program content
// 
// *********************************************************************

#include "mbed.h"
#include "SwAnalog.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

SwAnalog sw(p20);  // p20(adinput) :sw0,sw1,sw2

enum{
        sw0 = 0,
        sw1,
        sw2
    };
                   
int main() {
    while(1) {
        //===========================================
        // sw edge data refresh
        //===========================================
        sw.refreshEdgeData();

        //===========================================
        // SW level action
        //===========================================        
        // sw0 : OFF:LED1=ON   ON:LED1=OFF
        led1 = sw.checkLevel(sw0);
        
        // sw1 : OFF:LED2=OFF  ON:LED2=ON
        led2 = !sw.checkLevel(sw1);
        
        //===========================================
        // SW edge action
        //===========================================
        // sw2 on edge : LED3 invert
        if(sw.checkEdgeOn(sw2) == 1){
            led3 = !led3;
        }
        
        // sw2 off edge : LED4 invert
        if(sw.checkEdgeOff(sw2) == 1){
            led4 = !led4;
        }
    }
        
 
}
