//======================================================================
//    SwAnalog.cpp
//
// 
//======================================================================
#define _SWANALOG_C

#include "mbed.h"
#include "SwAnalog.h"

//======================================================================
// syokika
//======================================================================

#ifdef LPC1768
    SwAnalog::SwAnalog(PinName adinput0, PinName adinput1, PinName adinput2, PinName adinput3, PinName adinput4,
                         PinName adinput5
                         ):
                         _adinput0(adinput0),   _adinput1(adinput1),   _adinput2(adinput2),   _adinput3(adinput3),   _adinput4(adinput4),
                         _adinput5(adinput5)
                         {
       
    //---------------------------------
    // touroku sareta Sw Suu wo kakunin
    //---------------------------------
    if(adinput0 != NC){D_swPinSuu = 1;}
    if(adinput1 != NC){D_swPinSuu = 2;}
    if(adinput2 != NC){D_swPinSuu = 3;}
    if(adinput3 != NC){D_swPinSuu = 4;}
    if(adinput4 != NC){D_swPinSuu = 5;}
    
    if(adinput5 != NC){D_swPinSuu = 6;}
    
    
    // sw ninsiki syuki 10[ms]
//  swCheckTimer.attach_us(this, &SwAnalog::input, Z_matchcycle); 
        
}
#else // ~LPC1768
    SwAnalog::SwAnalog(PinName adinput0, PinName adinput1
                         ):
                         _adinput0(adinput0),   _adinput1(adinput1)
                         {
       
    //---------------------------------
    // touroku sareta Sw Suu wo kakunin
    //---------------------------------
    if(adinput0 != NC){D_swPinSuu = 1;}
    if(adinput1 != NC){D_swPinSuu = 2;}
   
    
    // sw ninsiki syuki 10[ms]
  swCheckTimer.attach_us(this, &SwAnalog::input, Z_matchcycle); 
        
}
#endif // LPC1768

//=================================================
// analog input data wo sw data ni henkan
//=================================================
void SwAnalog::adInput(float ad, uint8_t swPinSuu){
    uint8_t ans = 0;    // SW ninsikichi   2bit = sw2, 1bit = sw1, 0bit = sw0  0:OFF 1:ON 
    
      
    // ad ninsikich kara sw jotai wo kakutei 
     
    if     (ad <= Z_threshold0_1){ans = 0;}
    else if(ad <= Z_threshold1_2){ans = 1;}
    else if(ad <= Z_threshold2_3){ans = 2;}
    else if(ad <= Z_threshold3_4){ans = 3;}
    else if(ad <= Z_threshold4_5){ans = 4;}
    else if(ad <= Z_threshold5_6){ans = 5;}
    else if(ad <= Z_threshold6_7){ans = 6;}
    else                         {ans = 7;}
    

    B_kariLevel[(swPinSuu * Z_swInNoMax) + 0] = ((B_kariLevel[(swPinSuu * Z_swInNoMax) + 0] << 1) |  (ans & 0x01)      );
    B_kariLevel[(swPinSuu * Z_swInNoMax) + 1] = ((B_kariLevel[(swPinSuu * Z_swInNoMax) + 1] << 1) | ((ans & 0x02) >> 1));
    B_kariLevel[(swPinSuu * Z_swInNoMax) + 2] = ((B_kariLevel[(swPinSuu * Z_swInNoMax) + 2] << 1) | ((ans & 0x04) >> 2));
}

//==========================================
// subeteno analog input port no sw ninsiki
//==========================================
void SwAnalog::input(void){
    // genzai level input
    switch(D_swPinSuu){
#ifdef LPC1768
    case 6:
        adInput(_adinput5, 5);
        //break;
    case 5:
        adInput(_adinput4, 4);
        //break;
    case 4:
        adInput(_adinput3, 3);
        //break;
    case 3:
        adInput(_adinput2, 2);
        //break;        
#endif // LPC1768
    case 2:
        adInput(_adinput1, 1);
        //break;        
    case 1:
        adInput(_adinput0, 0);
        //break;                       
    default:
        // nothing
        break;
    }
    
    // kakutei Level kosin
    uint8_t kakutei = 0;
    for(uint8_t swPinSuu = 0; swPinSuu < D_swPinSuu; swPinSuu++){
        for(uint8_t swInNo = 0; swInNo < Z_swInNoMax; swInNo++){
            uint8_t work = B_kariLevel[(swPinSuu * Z_swInNoMax) + swInNo] & Z_itchiPattern;
            if(work == 0x00){
                // off kakutei
                D_oldLevel[(swPinSuu * Z_swInNoMax) + swInNo] = D_nowLevel[(swPinSuu * Z_swInNoMax) + swInNo];
                D_nowLevel[(swPinSuu * Z_swInNoMax) + swInNo] = Z_levelOff;
                kakutei = 1;
            }
            else if(work == Z_itchiPattern){
                // on kakutei
                D_oldLevel[(swPinSuu * Z_swInNoMax) + swInNo] = D_nowLevel[(swPinSuu * Z_swInNoMax) + swInNo];
                D_nowLevel[(swPinSuu * Z_swInNoMax) + swInNo] = Z_levelOn;
                kakutei = 1;
            }
            else{
                // nothing
            }
        
            if(kakutei == 1){
                // edge kosin
                if((D_oldLevel[(swPinSuu * Z_swInNoMax) + swInNo] == Z_levelOff) && (D_nowLevel[(swPinSuu * Z_swInNoMax) + swInNo] == Z_levelOn)){
                    B_edgeOn[(swPinSuu * Z_swInNoMax) + swInNo] = Z_edgeAri;
                }
                if((D_oldLevel[(swPinSuu * Z_swInNoMax) + swInNo] == Z_levelOn) && (D_nowLevel[(swPinSuu * Z_swInNoMax) + swInNo] == Z_levelOff)){
                    B_edgeOff[(swPinSuu * Z_swInNoMax) + swInNo] = Z_edgeAri;
                }
            }
        }
    }              
}

//========================================
// sw no ninsiki level ,edge data no kosin
//========================================
void SwAnalog::refreshEdgeData(void){
    for(uint8_t swPinSuu = 0; swPinSuu < D_swPinSuu; swPinSuu++){
        for(uint8_t swInNo = 0; swInNo < Z_swInNoMax; swInNo++){
            __disable_irq();     // Disable Interrupts
            D_edgeOn [(swPinSuu * Z_swInNoMax) + swInNo] = B_edgeOn [(swPinSuu * Z_swInNoMax) + swInNo];
            D_edgeOff[(swPinSuu * Z_swInNoMax) + swInNo] = B_edgeOff[(swPinSuu * Z_swInNoMax) + swInNo];
        
            B_edgeOn [(swPinSuu * Z_swInNoMax) + swInNo] = Z_edgeNasi;
            B_edgeOff[(swPinSuu * Z_swInNoMax) + swInNo] = Z_edgeNasi;
            __enable_irq();     // Enable Interrupts
        }
    }
}

//===============================
// sw no Off to On edge hantei
//===============================
uint8_t SwAnalog::checkEdgeOn(uint8_t swNo){
    uint8_t ans = 0;
    
    if(D_edgeOn[swNo] == Z_edgeAri){
        ans = 1;
    } 

    return (ans);
}

//===============================
// sw no On to Off edge hantei
//===============================
uint8_t SwAnalog::checkEdgeOff(uint8_t swNo){
    uint8_t ans = 0;
    
    if(D_edgeOff[swNo] == Z_edgeAri){
        ans = 1;
    } 

    return (ans);
}

//==============================
// sw no ninsiki level hantei
//==============================
uint8_t SwAnalog::checkLevel(uint8_t swNo){
    uint8_t ans = 0;
    
    if(D_nowLevel[swNo] == Z_levelOn){
        ans = 1;
    } 

    return (ans);
}

