//=============================================
// Sound Library Example Program
//  This sample program will play a single note
//
// <schematic>
//
//                                               /
//   mbed                 --------------      --/
//   p21(pwmOut)     -----| R:200[ohm] |-----|  |  speaker
//                        --------------     |  |
//                                           |  |
//   p10(DigitalOut) ------------------------|  |
//                                            --\
//                                               \
//==============================================
#include "mbed.h"
#include "Sound.h"

Sound sound(p21, p10);

int main() {
    while(1) {
        // tone1 (G5 Pronunciation time = 200ms, envelope time = 100ms)
        Sound::sound_t oto = {1,0x95,200,100};
        sound.sound_sound(oto);                 // To start the sound output
        while(sound.sound_sound() == true){}    // Wait until the end of the sound output

        // tone2 (A5 Pronunciation time = 2000ms, envelope time = 1000ms)
        oto.hanon = 1; oto.onkai = 0xA5; oto.time = 2000; oto.envelope = 1000;
        sound.sound_sound(oto);
        while(sound.sound_sound() == true){}
       
    }
}
