//=============================================
// Sound Library Example Program
//  This sample program will play a melody
//  Melody data for this program is set in the program as a data table.(DEMEKIN[])
// <schematic>
//
// <LPC1768>
//                                               /
//   mbed                 --------------      --/
//   p21(pwmOut)     -----| R:200[ohm] |-----|  |  speaker
//                        --------------     |  |
//                                           |  |
//   p23(DigitalOut) ------------------------|  |
//                                            --\
//                                               \
//
// <LPC1114FN28>
//                                               /
//   mbed                 --------------      --/
//   db1(pwmOut)     -----| R:200[ohm] |-----|  |  speaker
//                        --------------     |  |
//                                           |  |
//   db2(DigitalOut) ------------------------|  |
//                                            --\
//                                               \
//==============================================
#include "mbed.h"
#include "Sound.h"

Sound sound(p21, p23);  // LPC1768 p21(PwmOut), p23(DigitalOut)
//    Sound sound(dp1, dp2); // LPC1114FN28 dp1(PwmOut), dp2(DigitalOut)

// "demekin no uta" melody data
    const Sound::sound_t DEMEKIN[] =     {
        //  onkai,hatuon jikan[ms]
        //   hanon siji 0:b(flat)   1:tujo  2:#(sharp)
        //   |  C1 - B9 kan deno onkai(Gx ha 9x ni okikae te siji)  0xFF=end data
        //   |  |   time (1/1[ms]/count)
        //   |  |   |    envelope(yoin) (1/1 [ms]/count)
        //   |  |   |    |
        {1,0xC5,600,500},     // de
        {1,0xE5,600,500},     // me
        {1,0x95,600,500},     // kin
        {1,0x00,600,500},

        {1,0xC5,600,500},     // de
        {1,0xE5,600,500},     // me
        {1,0x95,600,500},     // kin
        {1,0x00,600,500},

        {1,0xC5,600,500},     // de
        {1,0xE5,600,500},     // me
        {1,0x95,600,500},     // kin
        {1,0x95,600,500},     // no
        {1,0x95,150,500},     // shi
        {1,0x00,900,500},
        {1,0xE5,750,500},     // po
        {1,0x00,450,500},

        {1,0xC5,600,500},     // de
        {1,0xE5,600,500},     // me
        {1,0x95,600,500},     // kin
        {1,0x00,600,500},

        {1,0xC5,600,500},     // de
        {1,0xE5,600,500},     // me
        {1,0x95,600,500},     // kin
        {1,0x00,600,500},

        {1,0x95,600,500},     // ju
        {1,0xE5,600,500},     // go
        {1,0xD5,600,500},     // n
        {1,0xC5,600,500},     // no
        {1,0xE5,150,500},     // shi
        {1,0x00,900,500},
        {1,0xC5,750,500},     // po
        {1,0x00,1350,500},

        {1,0xFF,1000,0},    // end

    };

   int main() {

        // Specifying the data to play melody
        sound.sound_enso((Sound::sound_t*)DEMEKIN);

        while(1) {
            if(sound.sound_enso() == false) {
                sound.sound_enso(true);
            }
            wait(10);
        }
    }

