//=============================================
// Sound Library Example Program
//  This sample program will play a melody
//  mbed drive to get the data from the melody
// 
// <schematic>
//
//                                               /
//   mbed                 --------------      --/
//   p21(pwmOut)     -----| R:200[ohm] |-----|  |  speaker
//                        --------------     |  |
//                                           |  |
//   p10(DigitalOut) ------------------------|  |
//                                            --\
//                                               \
//==============================================
#include "mbed.h"
#include "Sound.h"


Sound sound(p21, p10);  // p21(PwmOut), p10(DigitalOut)

int main() {

    // mbed drive to get the data from the melody
    sound.sound_enso("/local/enso.txt");
    while(1) {
        if(sound.sound_enso() == false){
            sound.sound_enso(true);
        }
       
    }
}
