/*************************************************
 * SevenSegLed Library sample program
 * 
 * <schematic>
 * 1.seven segment numeric LED Display : OSL40562-LR
 *       http://akizukidenshi.com/download/OSL40562-LR.pdf
 *
 *  OSL40562-LR                          Resister        LPC1768
 *  Pin No     Function                   [ohm]           PinNo
 *  ---------------------------------------------------------------------------
 *   1         segment E                   100            p10 
 *   2         segment D                   100            p11
 *   3         segment Dp                  100            p12
 *   4         segment C                   100            p13
 *   5         segment G                   100            p14
 *   6         common  4                   -              p15  
 *   7         segment B                   100            p26
 *   8         common  3                   -              p27 
 *   9         common  2                   -              p28
 *  10         segment F                   100            p29
 *  11         segment A                   100            p30
 *  12         common  1                    -             p21
 * 
 **************************************************/

#include "mbed.h"
#include "SevenSegLed.h"

 //                     common type (0:anode common 1:cathode common)
 //                     | 
 //                     |  display mode (0:smooth 1:hard)
 //                     |  |
 //                     |  |    segA segB segC segD segE segF segG segP com1 com2 com3 com4 (com5,com6,com7,com8 = NC)                          
 //                     |  |    |    |    |    |    |    |    |    |    |    |    |    | 
SevenSegLed sevenSegLed(1, 0, p30, p26, p13, p11, p10, p29, p14, p12, p21, p28, p27, p15);   // OSL40562-LR

//================================
// display buffer
//================================
//                   com1
//                   |  com2
//                   |  |  com3
//                   |  |  |  com4
//                   |  |  |  |
uint8_t D_7seg[4] = {0, 0, 0, 0};   // 0x0 to 0x9 = "0" to "9" ,0xA to 0xF = "A" to "F", 0x10 = extinction
uint8_t D_dot[4]  = {0, 1, 0, 0};   // 0:extinction  1: light


//==============================
// Variable counter & work
//==============================
uint8_t count = 0;      // free run counter (0x00 to 0xFF overflow to 0x00)
uint8_t work;

//==============================
// main 
//==============================
int main() {
 
    while(1) {
 
       //==========================
       // Show hexadecimal
       //==========================
        work = count / 0x10;
        D_7seg[0] = work;
         
        work = count % 0x10;
        D_7seg[1] = work;
        
        //========================
        // Show decimal
        //========================
        work = count / 10;
        work %= 10;
        D_7seg[2] = work;

        work = count % 10;
        D_7seg[3] = work;

        //=======================
        // Show dot
        //=======================
        if((count % 2) == 0){
            D_dot[1] = 1;
            D_dot[3] = 0;
        }
        else{
            D_dot[1] = 0;
            D_dot[3] = 1;
        }

        D_dot[0] = 0;
        //D_dot[1] = 0;
        D_dot[2] = 0;
        //D_dot[3] = 0;
 
        //==============================
        // set dynamic output data
        //==============================
         sevenSegLed.SevenSegLed_main(D_7seg, D_dot);       
 
        //==============================
        // counter increment & time wait
        //==============================
        count++;

        wait(1.0);

    }
}
