/*----------------------------------------------------------------------------*/
/* File Information                                                           */
/*----------------------------------------------------------------------------*/
/* Name       : types.h                                                       */
/* Type       : C Programming Language Header                                 */
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

#ifndef __TYPES_H__
#define __TYPES_H__

#include "stdint.h"
/*
typedef char                    int8_t;
typedef unsigned    char        uint8_t;
typedef signed      short       int16_t;
typedef unsigned    short       uint16_t;
typedef signed      int         int32_t;
typedef unsigned    int         uint32_t;
typedef signed      long long   int64_t;
typedef unsigned    long long   uint64_t;
*/
//typedef bool                bool_t;
typedef enum{TRUE, FALSE} bool_t;

//=========================================================================
//    byte bit access
//=========================================================================
typedef union{                    //    BYTE/NIBBLE/BIT access
    uint8_t byte;                //    Byte access
    struct{                        //    Nibble access
        uint8_t lo : 4;        //        lower(Bit0 - 3)
        uint8_t hi : 4;        //        upper(Bit4 - 7)
    }nibble;
    struct{                        //    Bit access
        uint8_t b0 : 1;        //        Bit0
        uint8_t b1 : 1;        //        Bit1
        uint8_t b2 : 1;        //        Bit2
        uint8_t b3 : 1;        //        Bit3
        uint8_t b4 : 1;        //        Bit4
        uint8_t b5 : 1;        //        Bit5
        uint8_t b6 : 1;        //        Bit6
        uint8_t b7 : 1;        //        Bit7
    }bits;
}byte_t;

//=========================================================================
//    word bit access
//=========================================================================
typedef union{                    //    WORD/BYTE/NIBBLE/BIT access
    uint16_t word;                //    Word access
    struct{                        //    Byte access
        uint8_t b0;            //        upper byte
        uint8_t b1;            //        lower byte
    }byte;
    struct    {                    //    Nibble access
        uint8_t n0 : 4;        //        lower byte low(Bit 0 -  3)
        uint8_t n1 : 4;        //        lower byte up (Bit 4 -  7)
        uint8_t n2 : 4;        //        upper byte low(Bit 8 - 11)
        uint8_t n3 : 4;        //        upper byte up (Bit12 - 15)
    }nibble;
    struct{                        //    Bit acces
        uint8_t b0 : 1;        //        Bit0
        uint8_t b1 : 1;        //        Bit1
        uint8_t b2 : 1;        //        Bit2
        uint8_t b3 : 1;        //        Bit3
        uint8_t b4 : 1;        //        Bit4
        uint8_t b5 : 1;        //        Bit5
        uint8_t b6 : 1;        //        Bit6
        uint8_t b7 : 1;        //        Bit7
        uint8_t b8 : 1;        //        Bit8
        uint8_t b9 : 1;        //        Bit9
        uint8_t b10: 1;        //        Bit10
        uint8_t b11: 1;        //        Bit11
        uint8_t b12: 1;        //        Bit12
        uint8_t b13: 1;        //        Bit13
        uint8_t b14: 1;        //        Bit14
        uint8_t b15: 1;        //        Bit15
    }bits;
}word_t;


//=========================================================================
//    ascii code
//=========================================================================
#define Z_NUL (0x00)
#define Z_SOH (0x01)
#define Z_STX (0x02)
#define Z_ETX (0x03)
#define Z_EOT (0x04)
#define Z_ENQ (0x05)
#define Z_ACK (0x06)
#define Z_BEL (0x07)

#define Z_BS  (0x08)
#define Z_HT  (0x09)
#define Z_LF  (0x0A)
#define Z_HM  (0x0B)
#define Z_FF  (0x0C)
#define Z_CR  (0x0D)
#define Z_SO  (0x0E)
#define Z_SI  (0x0F)

#define Z_DLE (0x10)
#define Z_DC1 (0x11)
#define Z_DC2 (0x12)
#define Z_DC3 (0x13)
#define Z_DC4 (0x14)
#define Z_NAK (0x15)
#define Z_SYN (0x16)
#define Z_ETB (0x17)


#endif    /* __TYPES_H__*/