/**********************************************************

*    SevenSegLed.cpp
*    dynamic control of seven segment led
*
**********************************************************/
#define _SEVENSEGLED_C

#include "types.h"
#include "mbed.h"
#include "SevenSegLed.h"




/** Create a seven segment led object connected to the specified DigtalOutput pin
 */
#ifdef USECOM4
SevenSegLed::SevenSegLed(uint8_t commonPole, uint8_t smooth, PinName seg_a, PinName seg_b, PinName seg_c, PinName seg_d, PinName seg_e, PinName seg_f, PinName seg_g, PinName seg_p,
                         PinName com_1, PinName com_2, PinName com_3, PinName com_4):
    _seg_a(seg_a), _seg_b(seg_b), _seg_c(seg_c), _seg_d(seg_d), _seg_e(seg_e), _seg_f(seg_f), _seg_g(seg_g), _seg_p(seg_p),
     _com_1(com_1), _com_2(com_2), _com_3(com_3), _com_4(com_4){
#else // ~USECOM4
SevenSegLed::SevenSegLed(uint8_t commonPole, uint8_t smooth, PinName seg_a, PinName seg_b, PinName seg_c, PinName seg_d, PinName seg_e, PinName seg_f, PinName seg_g, PinName seg_p,
                         PinName com_1, PinName com_2, PinName com_3, PinName com_4, PinName com_5, PinName com_6, PinName com_7, PinName com_8):
    _seg_a(seg_a), _seg_b(seg_b), _seg_c(seg_c), _seg_d(seg_d), _seg_e(seg_e), _seg_f(seg_f), _seg_g(seg_g), _seg_p(seg_p),
     _com_1(com_1), _com_2(com_2), _com_3(com_3), _com_4(com_4), _com_5(com_5), _com_6(com_6), _com_7(com_7), _com_8(com_8){
#endif // USECOM4
    
//@SS131223    timer.attach_us(this, &SevenSegLed::segmentGrayDataKosin, 10000);       // led smooth control 10ms timer inttruupt   //@SS131223
    timer.attach_us(this, &SevenSegLed::output, 1000);       // led output process 1ms timer inttruupt      //@SS131223
    // data table set of Brightness
    // DT_pwmGray[] = i ^ 2
    for(uint32_t i = 0; i < Z_grayMax + 1; i++){
        DT_pwmGray[i] = (uint8_t)(((i * i) * Z_pwmGrayMax ) / (Z_grayMax * Z_grayMax));
    }
    
    // check connect com_x
    D_comNull = Z_ketaSuu;
#ifndef USECOM4    
    if(com_8 == NC){D_comNull--;}
    if(com_7 == NC){D_comNull--;}
    if(com_6 == NC){D_comNull--;}
    if(com_5 == NC){D_comNull--;}
#endif //USECOM4
    if(com_4 == NC){D_comNull--;}
    if(com_3 == NC){D_comNull--;}
    if(com_2 == NC){D_comNull--;}
    if(com_1 == NC){D_comNull--;}
    
    // Those who will be reading the LED display
    D_smooth = smooth;
    
    // common and segment pin display data set
    if(commonPole == 0){
        // Anode common
        D_commonOn   = 1;
        D_commonOff  = 0;
        D_segmentOn  = 0;
        D_segmentOff = 1;
    }
    else{
        // Cathod common
        D_commonOn   = 0;
        D_commonOff  = 1;
        D_segmentOn  = 1;
        D_segmentOff = 0;
    }
    
}

/**************************************
* display henka set
* 0:smooth 1:hard
* @SS131130
**************************************/
void SevenSegLed::smoothSet(uint8_t smooth){    
    D_smooth = smooth;
}
    

/**************************************
* 7segment no gray data kosin
* 100ms goto no syori
**************************************/
void SevenSegLed::segmentGrayDataKosin(void){
    uint8_t keta;
    uint8_t seg;
    
    uint8_t segMask;
    uint8_t segData;


    //*********************************************************
    // 7segment no shuturyoku pattern
    //*********************************************************
                              //          seg: a b c d  e f g p
                              //          bit: 7 6 5 4  3 2 1 0
                              //          ---------------------
    #define D_0 (0xfc)        // 0             1 1 1 1  1 1 0 0
    #define D_1 (0x60)        // 1             0 1 1 0  0 0 0 0
    #define D_2 (0xda)        // 2             1 1 0 1  1 0 1 0
    #define D_3 (0xf2)        // 3             1 1 1 1  0 0 1 0
    #define D_4 (0x66)        // 4             0 1 1 0  0 1 1 0
    #define D_5 (0xb6)        // 5             1 0 1 1  0 1 1 0
    #define D_6 (0xbe)        // 6             1 0 1 1  1 1 1 0
    #define D_7 (0xe4)        // 7             1 1 1 0  0 1 0 0
    #define D_8 (0xfe)        // 8             1 1 1 1  1 1 1 0
    #define D_9 (0xf6)        // 9             1 1 1 1  0 1 1 0
    #define D_A (0xee)        // A             1 1 1 0  1 1 1 0    
    #define D_b (0x3e)        // b             0 0 1 1  1 1 1 0
    #define D_C (0x9c)        // C             1 0 0 1  1 1 0 0
    #define D_d (0x7a)        // d             0 1 1 1  1 0 1 0        
    #define D_E (0x9e)        // E             1 0 0 1  1 1 1 0    
    #define D_F (0x8e)        // F             1 0 0 0  1 1 1 0
    #define D_NULL (0x00)     // NULL          0 0 0 0  0 0 0 0
                              // (No indication)
        
        
    const unsigned char DT_segData[17] = {D_0, D_1, D_2, D_3, D_4, D_5, D_6, D_7, D_8, D_9, D_A, D_b, D_C, D_d, D_E, D_F, D_NULL};
    uint8_t work;

    for(keta = 0; keta < Z_ketaSuu; keta++){
        // number data set
        work = D_7seg[keta];
        if(work > 0x10){work = 0x10;}       // error data then NULL
        segData = DT_segData[work];
        
        // dot data set
        if(D_dot[keta] != 0){segData |= 0x01;}
        
        // segment data set
        segMask = 0x80;
        
        for(seg = 0; seg < Z_segSuu; seg++){
            if(D_smooth == Z_smooth){
                // LED display Smooth
                if((segData & segMask) != 0){
                    // segment tento
                     if(D_7segGray[keta][seg] < Z_grayMax){D_7segGray[keta][seg]++;}
                }
                else{
                    // segment syoto
                    if(D_7segGray[keta][seg] > 0){D_7segGray[keta][seg]--;}
                }
                segMask = segMask >> 1;
            }
            else{
                // LED display Hard
                if((segData & segMask) != 0){
                // segment tento
                    D_7segGray[keta][seg] = Z_pwmGrayMax;
                }
                else{
                    // segment syoto
                    D_7segGray[keta][seg] = 0;
                }
                segMask = segMask >> 1;
            }
       }
    }
}


/**************************************
* main
**************************************/
void SevenSegLed::SevenSegLed_main(uint8_t* number, uint8_t* dot) {
    
    for(uint8_t i = 0; i < Z_ketaSuu; i++){
        D_7seg[i] = number[i];
        D_dot[i]  = dot[i];
    }
      
 
        // dynamic shuturyoku shori
 //segmentGrayDataKosin();
 //@SS131223       output();        //@SS131223
}


/**************************************
* comAllClear
*
* common pin o subete OFF suru
**************************************/
void SevenSegLed::comAllClear(void){
    
    switch (D_comNull){
#ifndef USECOM4
    case 8:                 // com_1 - com_8is all connect
        _com_8 = D_commonOff;
        //break;
    case 7:                 // com_8 Null
        _com_7 = D_commonOff;
        //break;
    case 6:                 // com_7 Null
        _com_6 = D_commonOff;
        //break;
    case 5:                 // com_6 Null
        _com_5 = D_commonOff;
        //break;
#endif // USECOM4
    case 4:                 // com_5 Null
        _com_4 = D_commonOff;
        //break;                                
    case 3:                 // com_4 Null
        _com_3 = D_commonOff;
        // break;
    case 2:                 // com_3 Null
        _com_2 = D_commonOff;
        //break;
    case 1:                 // com_2 Null
        _com_1 = D_commonOff;
        //break;
    case 0:                 // com_1 Null
        // nothing
        break;
    default:
        // nothing
        break;
    }
}

/**************************************
* segAllClear
*
* segment pin o subete OFF suru
**************************************/
void SevenSegLed::segAllClear(void){
    _seg_a = D_segmentOff;
    _seg_b = D_segmentOff;
    _seg_c = D_segmentOff;
    _seg_d = D_segmentOff;
    _seg_e = D_segmentOff;
    _seg_f = D_segmentOff;
    _seg_p = D_segmentOff;
}

/**************************************
* segDataSet
*
* segment pin ni shuturyoku data o settei
**************************************/
void SevenSegLed::segDataSet(uint8_t keta){

    for(uint8_t i = 0; i < Z_pwmGrayMax + 1; i++){
        if(DT_pwmGray[D_7segGray[keta][0]] <= i){_seg_a = D_segmentOff;}else{_seg_a = D_segmentOn;}
        if(DT_pwmGray[D_7segGray[keta][1]] <= i){_seg_b = D_segmentOff;}else{_seg_b = D_segmentOn;}
        if(DT_pwmGray[D_7segGray[keta][2]] <= i){_seg_c = D_segmentOff;}else{_seg_c = D_segmentOn;}
        if(DT_pwmGray[D_7segGray[keta][3]] <= i){_seg_d = D_segmentOff;}else{_seg_d = D_segmentOn;}
        if(DT_pwmGray[D_7segGray[keta][4]] <= i){_seg_e = D_segmentOff;}else{_seg_e = D_segmentOn;}
        if(DT_pwmGray[D_7segGray[keta][5]] <= i){_seg_f = D_segmentOff;}else{_seg_f = D_segmentOn;}
        if(DT_pwmGray[D_7segGray[keta][6]] <= i){_seg_g = D_segmentOff;}else{_seg_g = D_segmentOn;}
        if(DT_pwmGray[D_7segGray[keta][7]] <= i){_seg_p = D_segmentOff;}else{_seg_p = D_segmentOn;}
    
    }
}

/**************************************
* output
*
* This function must be treated with 1ms interval.
* Each time you run this function, to switch the common.
* 
**************************************/
void SevenSegLed::output(void){
    static uint8_t M_seg = 0;
    static uint8_t count = 0;   // This counter is used to perform a single smooth processing 10ms

    if(M_seg >= D_comNull){M_seg = 0;}

   //com, seg syokika
    comAllClear();
    segAllClear();
  
    // common output
    if(D_comNull != 0){
        // If the terminal output processing
        switch(M_seg){
        case 0:
            _com_1 = D_commonOn;
            break;
        case 1:
            _com_2 = D_commonOn;
            break;
        case 2:
            _com_3 = D_commonOn;
            break;
        case 3:
            _com_4 = D_commonOn;
            break;
#ifndef USECOM4
        case 4:
            _com_5 = D_commonOn;
            break;
        case 5:
            _com_6 = D_commonOn;
            break;                    
        case 6:
            _com_7 = D_commonOn;
            break;                    
        case 7:
            _com_8 = D_commonOn;
            break;                                                
#endif // USECOM4
        default:
            break;
        }
    }
    
    // segmant output
    if(M_seg < Z_ketaSuu){
        segDataSet(M_seg);
    }


//    com, seg syokika
//    comAllClear();
//    segAllClear();
    M_seg++;

    // gray data process                                //@SS131223
    // It is performed in 10ms intervals smooth process //@SS131223
    count++;                                            //@SS131223
    if(count > 9){                                      //@SS131223
        count = 0;                                      //@SS131223
        segmentGrayDataKosin();                         //@SS131223
    }                                                   //@SS131223
}


