#include "mbed.h"

// TLC5940 control pin setting
SPI spi(p5, p6, p7);    //SIN (p6), SCLK,GSCLK(p7)

DigitalOut XLAT(p20);
DigitalOut BLANK(p19);

DigitalOut myled1(LED1);
DigitalOut myled3(LED3);

/*
DigitalOut DIGIT1(p21);
DigitalOut DIGIT2(p22);
DigitalOut DIGIT3(p24);
DigitalOut DIGIT4(p25);
DigitalOut DIGIT5(p23);
*/

/**********************************
* dynamic output for com
**********************************/
/*
void comOut(void){
    static int cnt = 0;
    
    // COM All Off
    DIGIT1 = 0;
    DIGIT2 = 0;
    DIGIT3 = 0;
    DIGIT4 = 0;
    DIGIT5 = 0;
    
    // COM out
    switch(cnt){
    case 0:
        DIGIT1 = 1;
        break;
    case 1:
        DIGIT2 = 1;
        break;   
    case 2:
        DIGIT3 = 1;
        break;
    case 3:
        DIGIT4 = 1;
        break;
    case 4:
        DIGIT5 = 1;
        break;
    default:
        cnt = 0;
        break;
    }
    
    if(++cnt > 4){cnt = 0;}
}
*/

/*********************************
* gray data set
*********************************/
void grayDataSet(int* p){
    static int lightWait = 0;
    static int D_gray = 0;

    #define Z_kasan (1)
    static int kasan = Z_kasan;
    
    lightWait++;
    if(lightWait == 1){
        lightWait = 0;
        D_gray += kasan;
            
        if(D_gray > 4095){
           D_gray = 4095;
           kasan = -Z_kasan;
           myled1 = 1;
        }
        else if(D_gray <= 0){
           D_gray = 0;
           kasan = Z_kasan;
           myled1 = 0;
        }
    }
        
    for(int i = 0; i < 16; i++){
        *(p + i) = D_gray;
    }
}


/**********************************
* SPI Initalize (for TLC5960 control)
**********************************/
void tlc5940SpiInitalize(void){
    spi.format(12,0);
    spi.frequency(30000000);
}

/*********************************
* TLC5940 Gray Data clear
*********************************/
void tlc5940GrayDataClear(void){
        for(int i = 0; i < 24; i++){
            int whoami = spi.write(0);
        }
        
        XLAT = 1;
        XLAT = 0;
}

/**********************************
* TLC5940 Gray Data Display & next data send
***********************************/
void tlc5940GrayDataDisplayAndSend(int* p){
    BLANK = 1;
    BLANK = 0;

    for(int i = 0; i < 326; i++){
        spi.write(0);
    }
    
    for(int i = 0; i < 16; i++){
        spi.write(*(p + i));
    }
    
    XLAT = 1;
    XLAT = 0;
}

/************************************
* main
************************************/
int main() {


    int D_grayData[16];     // gray data = 0 to 4095   [0]:OUT0, [1]:OUT1, ...,[14]:OUT14, [15]:OUT15


    // SPI initalize
    tlc5940SpiInitalize();    

    tlc5940GrayDataClear();
    

    while(1) {
    
//        comOut();

        grayDataSet(D_grayData);
        
        tlc5940GrayDataDisplayAndSend(D_grayData);
        

    
    }
}
