/**
    Transistor Gijutsu 2014nen 3gatugo page.64 3syo
    Buletooth ban
    LPC810 wo LPC1768 ni henko sita sample program


RN-42XVP   LPC1768
-------------------
Pin1       VOUT
Pin2       p14(rx)
Pin3       p13(tx)
Pin10      GND   

*/
#include "mbed.h"

BusOut myleds(LED1, LED2, LED3, LED4);

Serial pc(USBTX, USBRX); // (tx, rx) 
Serial xbee(p13, p14);    // (tx,rx) RN-42XVP tuusinyo serial

int main()
{
    uint8_t rawData;
    uint8_t newData;

    xbee.baud(115200);

    while(1) {

        if(1 == xbee.readable()) {
            rawData = xbee.getc();

            pc.printf("rawData = %02x\n",rawData);
            
            if(rawData != 0x00) {
                if(rawData == '+') {
                    newData = 0x0f;
                } else if(rawData == '-') {
                    newData = 0x00;
                } else if(rawData == '0') {
                    newData = 0x0a;
                } else {
                    newData = rawData - '0';
                }

                myleds = newData;


            }

        }
    }
}
