/**
 * IR receiver (Version 0.0.4)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 *
 * -------------------------------------------------------
 * 130616 suupen
 * IRC Helicopter "SWIFT" Propo support
 *  Conditional compilation 
 *      "SWIFT_PROTCOL"
 *      "IR_RAW_DATA_ANALYSIS"
 *      "ERRORWAIT" : recive error no fuuki taisaku
 *--------------------------------------------------------
 */

#ifndef _RECEIVER_IR_H_
#define _RECEIVER_IR_H_

#include <mbed.h>

#include "RemoteIR.h"

//#define IR_RAW_DATA_ANALYSIS
#define ERRORWAIT

/**
 * IR receiver class.
 */
class ReceiverIR {
public:

    /**
     * Constructor.
     *
     * @param rxpin Pin for receive IR signal.
     */
    explicit ReceiverIR(PinName rxpin);
    
    /**
     * Destructor.
     */
    ~ReceiverIR();

    /**
     * State.
     */
    typedef enum {
        Idle,
        Receiving,
        Received,
#ifdef ERRORWAIT        
        ErrorWait, 
#endif // ERRORWAIT
    } State;
    
    /**
     * Get state.
     *
     * @return Current state.
     */
    State getState();
    
    /**
     * Get data.
     *
     * @param format Pointer to format.
     * @param buf Buffer of a data.
     * @param bitlength Bit length of the buffer.
     *
     * @return Data bit length.
     */
    int getData(RemoteIR::Format *format, uint8_t *buf, int bitlength);
    
private:
    
    typedef struct {
        RemoteIR::Format format;
        int bitcount;
        uint8_t buffer[64];
    } data_t;
    
    typedef struct {
        State state;
        int c1;
        int c2;
        int c3;
        int d1;
        int d2;
    } work_t;
    
 #ifdef IR_RAW_DATA_ANALYSIS
    typedef struct {
        State state;
        int timecount[1000];   // Hi,Lo count (1/1 [us]/count)
        int bitcount;
    } check_t;
#endif //IR_RAW_DATA_ANALYSIS

    InterruptIn evt;    /**< Interrupt based input for input. */
    Timer timer;        /**< Timer for WDT. */
    Ticker ticker;      /**< Tciker for tick. */
    Timeout timeout;    /**< Timeout for tail. */

    data_t data;
    work_t work;
 #ifdef IR_RAW_DATA_ANALYSIS
    check_t check;
#endif //IR_RAW_DATA_ANALYSIS
   
    void init_state(void);

#ifdef ERRORWAIT
    void errorWait(void);
#endif // ERRORWAIT

    void isr_wdt(void);
    void isr_fall(void);
    void isr_rise(void);
    
    /**
     * ISR timeout for tail detection.
     */
    void isr_timeout(void);

};

#endif

