#include "mbed.h"
#include "MSCFileSystem.h"
//#include <stat.h>
#include "string.h"

/*
**************************************************************************************************************
*                                        PRINT CONFIGURATION
**************************************************************************************************************
*/

//#define DEBUG
#ifdef DEBUG
#define DEBUG_PRINT(...) printf(__VA_ARGS__)
#else
#define DEBUG_PRINT(...)
#endif // DEBUG


#define FSNAME "msc"
MSCFileSystem msc(FSNAME);
FILE *fp;



char fileName[20];
char buffer[50];

int32_t C_lineReadNo;  // fileLineRead()で１行づつ読み出したときに、読み出した行番号を記憶する 0:先頭行 1～その後の行

/** usb check
 * @return 0:OK 1:NG
 */
int usbMemoryCheck(void)
{
    return(msc.disk_usbCheck());
}

/** usb memory initialize
 * @return 0:OK 1:NG
 */
int usbMemoryInitialize(void)
{
    return(msc.disk_initialize());
}

/** File check
 * @para fileNumber : This number get filename 0,1:first 2: second ...
 * @para *fileName  : get filename
 * @para *fileNumberMax : .prn file number
 * @return
 *  false: non file true: file exists
 */
int32_t fileDetect(int32_t fileNumber, char *fileName, int32_t *fileNumberMax)
{
    uint32_t numMax = 0;
    int32_t ans = false;

    DIR *d;
    struct dirent *p;

    d = opendir("/" FSNAME);

    // directory check
    if ( d != NULL ) {
        while ( (p = readdir(d)) != NULL ) {
            if(NULL != strstr(p->d_name, ".prn")) {
                numMax++;
                if(numMax == fileNumber) {
                    strcpy(fileName, p->d_name);
                }
                DEBUG_PRINT("detect = %s\n",fileName);
                ans = true;
            }
        }
        *fileNumberMax = numMax;
    }
    closedir(d);
    return ans;
}

/** 指示したfileの行数を取得
 * @param *fileName : 指示するfile name
 * @param *numberLine : 取得した行数
 * @return false:行数取得できず true:処理成功
 */
int32_t fileSelect(char *fileName, int32_t *numberLine)
{
    uint32_t numMax = 0;
    int32_t ans = false;

    /*
      DIR *d;
      struct dirent *p;

      d = opendir("/" FSNAME);
    */
    // file check
    sprintf(buffer,"/msc/%s",fileName);
    fp = fopen( buffer, "r");

    if ( fp != NULL ) {
        char buf[256];
        while ( NULL != fgets(buf, sizeof(buf), fp) ) {
            // DEBUG_PRINT("%s", buf);
            numMax++;
        }
        *numberLine = numMax;
        ans = true;

    } else {
        // Don't file open
        // nothing
    }

    fclose(fp);
    return ans;
}

/** 指定した行のデータを取得
 * @param *fileNmae データを取得するfile Name
 * @param *data : 取得した行データを格納するバッファ
 * @param dataNumber : *dataのbyte数
 * @param numberLine : 取得する行数
 * @return false:失敗 true:成功
 *
 * 181014 数万行になると読み込みが遅くなるのでtempNumber行分バッファし、毎回指定行まで空回りさせないようにする
 */
int32_t fileOneLineRead(char *fileName, char *data, int32_t dataNumber, int32_t numberLine)
{
//    static FILE *fp;
    uint32_t i;
    int32_t ans = false;

#define tempNumber 600
#define tempSize 30
    static char temp[tempNumber][tempSize]; // tempNumber行分のデータをバッファしておく
    static uint32_t tempLineStartNo = 0;     // tempの先頭行番号
    static int32_t tempCheck = -1;       // tempにデータがあるか判別 -1:なし それ以外あり

#define bufferNumber 100
    char buffer[bufferNumber];



    if (((numberLine / tempNumber) == (tempLineStartNo / tempNumber)) && (tempCheck != -1)) {
        // tempにデータがあればそこから取り出す
        strcpy(data, &temp[numberLine % tempNumber][0]);
        ans = true;
        DEBUG_PRINT("temp numberLine = %d, tempNumber = %d\r\n",numberLine, (tempLineStartNo / tempNumber));
    } else {
        // tempにデータがなければUSBから取り出し、tempにも保存する
        sprintf(buffer,"/msc/%s",fileName);
        fp = fopen( buffer, "r");
        if ( fp != NULL ) {
            tempLineStartNo = (numberLine /tempNumber) * tempNumber;

            // 目的の行まで空回し
            for(i = 0; i < ((numberLine / tempNumber) * tempNumber) ; i++) {
                fgets(buffer, sizeof(buffer), fp);
            }

            // 目的の行からtempに保管していく
            for(i = 0; i < tempNumber ; i++) {
                if(NULL != fgets(&temp[i][0], tempSize, fp)) {
                    tempCheck = 1;
                } else {
                    // fileにデータがなければ強制終了
                    break;
                    //i = tempNumber;
                }
            }

            // fileから取り出した回もtempからデータを取得
            if((numberLine % tempNumber) <= i) {
                strcpy(data, &temp[numberLine % tempNumber][0]);
                ans = true;
                DEBUG_PRINT("temp = %d\r\n",numberLine % tempNumber);
            } else {
                // nothing
            }

        } else {
            // Don't file open
            // nothing
        }
        fclose(fp);

    }

    return ans;
}

/** file open
 * @param *fileName : 指示するfile name
 * @return false:openできず true:処理成功
 */
int32_t fileOpen(char *fileName)
{
    int32_t ans = false;

    sprintf(buffer,"/msc/%s",fileName);
    fp = fopen( buffer, "r");

    if ( fp != NULL ) {
        C_lineReadNo = 0;   // fileLineRead()で読み出したときの行番号
        ans = true;
    } else {
        // Don't file open
        // nothing
    }

    return ans;
}

/** file close
 * @param *fileName : 指示するfile name (関数内で使用しないが、コール元での明示用に設定させる)
 * @return (false:ありえない) true:処理成功
 */
int32_t fileClose(char *fileName)
{
    int32_t ans = true;

    fclose(fp);
    return ans;
}

/** 順番に１行づつ読み出す
 * @param *fileNmae データを取得するfile Name
 * @param *data : 取得した行データを格納するバッファ
 * @param dataNumber : *dataのbyte数
 * @param numberLine : 読み出した行番号(0:読み出し無し 読み出した行番号:1,2・・・)
 * @return false:失敗 true:成功
 */
int32_t fileLineRead(char *fileName, char *data, int32_t dataNumber, int32_t *numberLine)
{
    int32_t ans = false;

    if(NULL != fgets(data, dataNumber, fp)) {
        *numberLine = C_lineReadNo;
        C_lineReadNo++;
        DEBUG_PRINT("line = %s\r\n", data);
        ans = true;
    } else {
        // nothing
    }
    return ans;
}