
#ifndef USBMEMORY_H
#define USBMEMORY_H

#include "usbMemory.h"

int32_t fileDetect(int32_t fileNumber, char *fileName, int32_t *fileNumberMax);
int32_t fileSelect(char *fileName, int32_t *numberLine);

// 関数を呼ぶたびにfile openして指定行まで空回しするので時間がかかる。その代わりopen-closeを考える必要がない
int32_t fileOneLineRead(char *fileName, char *data, int32_t dataNumber, int32_t numberLine);

// fileをopenしっぱなしにして先頭から順番に読むときに使う関数郡(fileOneLineRead()を使うとストレス二なる場合に使う)
int32_t fileOpen(char *fileName);
int32_t fileClose(char *fileName);
int32_t fileLineRead(char *fileName, char *data, int32_t dataNumber, int32_t *numberLine);

int usbMemoryCheck(void);

int usbMemoryInitialize(void);




#endif // USBMEMORY_H