#ifndef MBED_MDX20_H
#define MBED_MDX20_H

#include "mbed.h"
#include "BufferedSerial.h"
#include "limits.h"
class MDX20
{
public:
    MDX20(PinName tx, PinName rx, PinName cts);

    ~MDX20();

    void clearPositon(void);
    void answerPositon(int16_t *position);
    void answerPositonMillimeter(float *position);
    void integralPosition(char *str);
    void userOriginPositionInitial(void);

    uint8_t xyOrigin(void);
    uint8_t zOrigin(void);


    uint8_t sendData(char* data);
    int32_t axisMovingCheck(char* data);

    uint8_t reciveData(void);

    int putc(int c);
    uint8_t initial(void);
    uint8_t motorOff(void);
    uint8_t motorOn(void);


    uint8_t userOriginInitial(void);
    uint8_t userXYOriginInitial(void);
    uint8_t userZOriginInitial(void);


    uint8_t final(void);
//    uint8_t zeroSetting(void);
    uint8_t XYZMove(int16_t x, int16_t y, int16_t z);
    void offsetXAxisAdjustment(int16_t axisData);
    void offsetYAxisAdjustment(int16_t axisData);
    void offsetZAxisAdjustment(int16_t axisData);

    int32_t motorStateCheck(void);
    int32_t connectCheck(void);


private:

    BufferedSerial _serial; // tx, rx(NC)
    DigitalIn _cts;

    void translationToControlerAxisMoveDataFromRMLAxisMoveData(char *str);


    char B_masterTx[0xff];
    int16_t D_position[3]; //[0]:x, [1]:y, [2]:z
    int16_t D_userOriginPosition[3]; //[0]:x, [1]:y, [2]:z
    int32_t motorState; // true:ON false:OFF

#define countToMillimeter (0.025)
#define Z_x (0)
#define Z_y (1)
#define Z_z (2)

#define Z_xAxisMin (0)
#define Z_xAxisMax (8128)

#define Z_yAxisMin (0)
#define Z_yAxisMax (6096)

#define Z_zAxisMin (-2420)
#define Z_zAxisMax (0)

};

#endif  //  MBED_MDX20_H