/**
 * @section DESCRIPTION
 * maker http://www.my-semi.com/content/products/product_mean.aspx?id=9
 * shop  http://akizukidenshi.com/catalog/g/gI-09678/
 *
 * sample program schematic
 *
 *                VOUT(3.3V)           VOUT                     VOUT  
 *                 |                   |VDD                      |VDD     
 *          --------------            -------------            --------------- 
 *          mbed(LPC1768)|            |MY9221(2)  |            |MY9221(1)    |
 *                    p5 |------------|DI     DO  | ---------- |DI           |
 *                    p10|------------|DCKI   DCKO| ---------- |DCKI         | 
 *                       |            |           |            |             |  
 *                       |  22kOhme --|REXT-C     |  22kOhme --|REXT-C       |  
 *                       |  22kOhme --|REXT-B     |  22kOhme --|REXT-B       |  
 *                       |  22kOhme --|REXT-A     |  22kOhme --|REXT-A       |  
 *          -------------             -------------            --------------  
 *                                     |.........|              |...........|
 *                                     LED1   LED12             LED1    LED12                            
 */

/*
MY9366
http://www.my-semi.com/content/products/product_mean.aspx?id=28
*/

#include "mbed.h"
#include "MY9221.h"
MY9221 MY9221(p5, p10, 2);  // di, clk, number

uint16_t D_gray[12] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
float D_gray2[12] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};

int main()
{

    MY9221.commandSet(MY9221::fast, MY9221::bit16, MY9221::freq1, MY9221::waveApdm, MY9221::internal, MY9221::workLed, MY9221::free, MY9221::repeat);


    while(1) {

        for(int i=0; i < 12; i++) {
            D_gray[i] += 0x100;
            D_gray2[i] += 0.01;
            if(D_gray2[i] > 1)D_gray2[i] = 0;
        }
        MY9221.dataRawSet(D_gray, 1);
        MY9221.dataSet(D_gray2, 2);
        wait_ms(20);                            // Image refresh Rate [s] < led gray data update cycle [s]
        MY9221.refresh();

    }
}
