/* spinner base pcb
 * <use ir propo>
 *      LPC1114FN28 sony format propo
 *
 * <spinner circit>
 * LPC1114FN28
 *  dp28 : ir reciver
 *  dp18,dp17,dp25: (pwm fwd rev) Right motor control
 *  dp2,dp4,dp6:(pwm fwd rev) Left motor control
 *
 *  dp11,dp13,dp14,dp26 (LED1,2,3,4):lookup the ir recive condition

*/

#include "mbed.h"
#include "Motor.h"

#include "ReceiverIR.h"

#define DBG
//#define DBG2    // motor dousa kakunin

#ifdef DBG
Serial pc(dp16, dp15);    //tx,rx
#endif // DBG

//-----------------------
// ir Library
ReceiverIR ir_rx(dp28);
RemoteIR::Format formatRx;
uint8_t bufRx[10];    // nomal no is "2".
int bitcountRx;

DigitalOut led1(dp11);
DigitalOut led2(dp13);
DigitalOut led3(dp14);
DigitalOut led4(dp26);


//-----------------------
// Motor Library
Motor Right(dp18, dp17, dp25);   // pwm,fwd,rev
Motor Left(dp2, dp4, dp6);      //  pwm,fwd,rev
//-----------------------

Timeout timeout;

void isr_timeout(void)
{
    Right.speed(0);
    Left.speed(0);

    timeout.detach();
    timeout.attach_us(&isr_timeout, 1000 * 1000);
}

void initialSpinner(void){

    timeout.detach();
    timeout.attach_us(&isr_timeout, 1000 * 1000);

}

void mainSpinner(void)
{
#ifdef DBG
    pc.baud(9600);
#endif // DBG

        // IR data Monitor
        led1 = 0;
        led2 = 0;
        led3 = 0;
        led4 = 0;

        switch(ir_rx.getState()) {
            case ReceiverIR::Idle:
                led1 = 1;
                break;
            case ReceiverIR::Receiving:
                led2 = 1;
                break;
            case ReceiverIR::Received:
                led3 = 1;
                break;
            default:
                led4 = 1;
                break;
        }
 
        if (ir_rx.getState() == ReceiverIR::Received) {
            bitcountRx = ir_rx.getData(&formatRx, bufRx, sizeof(bufRx) * 8);

            if((formatRx == RemoteIR::SONY) && (bitcountRx == 16)) {

                timeout.detach();
                timeout.attach_us(&isr_timeout, 1000 * 1000);

                float xWork = (float)((int8_t)bufRx[0] / 8.0f);
                float yWork = (float)((int8_t)bufRx[1] / 8.0f);
                
                // fukantai (-0.2 - 0.2)
                if((-0.2 <= xWork) && (xWork <= 0.2)){xWork = 0;}
                if((-0.2 <= yWork) && (yWork <= 0.2)){yWork = 0;}
                
                yWork = -yWork; // sousa wo hanten.

                float r = yWork + (xWork / 2.0);
                float l = yWork - (xWork / 2.0);

                if(-1.0 > r) {
                    r = -1.0;
                }
                if( 1.0 < r) {
                    r =  1.0;
                }
                if(-1.0 > l) {
                    l = -1.0;
                }
                if( 1.0 < l) {
                    l =  1.0;
                }


#ifdef DBG
                pc.printf("x = %02d y = %02d     |xWork = %1.1f yWork = %1.1f       |r = %1.1f l = %1.1f \r\n",(int8_t)bufRx[0],(int8_t)bufRx[1],xWork,yWork,r,l);
#endif // DBG

                Right.speed(r);
                Left.speed(-l);

  

            }
        }
}

