/* ir propo
 * microcomputer
 *      LPC1114FN28
 *          used pin
 *          dp1 : irLED output
 *          dp9 : analog joystic x axis input
 *          dp10: analog joystic y axis input
 * joystic
 *      akizuki(http://akizukidenshi.com/catalog/g/gP-04048/)
 *      analog joystic
 *      <schematic>
 *          Vcc(3.3[V]) : joystic pin1'(X axis)  pin3(Y axis)
 *          GND(0[V])   : joystic pin3'(X axis)  pin1(Y axis)
 *          LPC1114FN28 dp9 : joystic pin2'(X axis)
 *          LPC1114FN28 dp10: joystic pin2 (Y axis)
 *      <joystic fixed data>
 *              X axis -8 to 7  :int8_t
 *              Y axis -8 to 7  :int8_t
 *
 * ir send
 *      akizuki (http://akizukidenshi.com/catalog/g/gP-04048/)
 *      OSI5FU3A11C
 *      <schematic>
 *          setting If=50[mA]
 *          LPC1114FN28 dp1 : irLED(anode)
 *          GND(0[V])       : - 40[ohm] - irLED(cathod)
 *      <send format>
 *          SONY format
 *          send cycle : 100[ms]
 *          buf[0] :x axis
 *          buf[1] :y axis
*/
#include "mbed.h"
#include "propo.h"
#include "TransmitterIR.h"


void interruptPropo(void);

//#define DBG_PROPO

#ifdef DBG_PROPO
DigitalOut myled(LED2);
Serial pc(dp16, dp15);
#endif // DBG_PROPO
//------------------------
// joystic
AnalogIn Xin(dp9);
AnalogIn Yin(dp10);

int8_t XinData;
int8_t YinData;
//-------------------------
// ir control
TransmitterIR ir_tx(dp1);
RemoteIR::Format format = RemoteIR::SONY;
uint8_t buf[2] = {0x00, 0x00};
int bitcount = 16;

Ticker timer;

void initialPropo(void)
{
    timer.attach(&interruptPropo, 0.1);
}

void interruptPropo()
{
    // analog 16bit unsigned data(uint16_t) to 4bit signed data(int8_t)
    XinData = (int8_t)((int16_t)(Xin.read_u16() >> 12) - 0x8);
    YinData = (int8_t)((int16_t)(Yin.read_u16() >> 12) - 0x8);

    buf[0] = XinData;
    buf[1] = YinData;

    // send data
    if(ir_tx.getState() == TransmitterIR::Idle) {
        bitcount = ir_tx.setData(format, buf, bitcount);
    }

#ifdef DBG_PROPO
    pc.printf("X = %02d, Y = %02d \r\n",XinData,YinData);
    myled = !myled;
#endif // DBG_PROPO 
}


