/**
 * Decode IR Propo HonyBee class
 *  Version 0.0     130623
 *
 * Writer:suupen
 */

#ifndef _DECODEHonyBee_H_
#define _DECODEHonyBee_H_

#include <mbed.h>
#include "CodecHonyBee.h"


/**
 * Decode class.
 */
class DecodeHonyBee {
public:


/**
 * Constructor
 */
  DecodeHonyBee();
  
/**
 * Destructor.
 */
  ~DecodeHonyBee();
    
/**
 * Get HonyBee propo analysis data.
 *
 * @param data IR recive data
 *
 * @param HonyBee Pointer to HonyBee.
 *
 * @return receive answer : ture:recive ok   false:recive ng.
 */
    bool decode(uint8_t *data, CodecHonyBee::honyBeePropo_t *HonyBee);

/**
 * Normalize HonyBee data.
 *
 * @param buf Pointer to propo recive data.
 *
 * @param propo normalize propo data.
 *
 * @return receive answer : ture:recive ok   false:recive ng.
 */
bool normalize(uint8_t *buf, CodecHonyBee::normalizePropo_t *propo);

private:
    
 


};

#endif


