/**
 * IR Propo Decode class
 * Version 0.0  130623
 *
 * Writer:suupen
 */
 #include "CodecHonyBee.h"
 #include "DecodeHonyBee.h"
 
 /**
 * Constructor DecodeHonyBee
 *
 */
 DecodeHonyBee::DecodeHonyBee(){
    // nothing
 }
 
 /**
 * Destructor.
 */
 DecodeHonyBee::~DecodeHonyBee(){
    // nothing
 }
 

/**
 * Get HonyBee controller data.
 *
 * @param data Pointer to propo recive data.
 *
 * @param HonyBee Pointer to HonyBee.
 *
 * @return receive answer : ture:recive ok   false:recive ng.
 */
bool DecodeHonyBee::decode(uint8_t *data, CodecHonyBee::honyBeePropo_t *honyBee) {

    bool ans = false;
    uint8_t wk1 = 0,wk2;
    int8_t ladder;
    uint8_t dat[3];
    uint8_t i;
    
    // MSB to LSB
    for(i = 0; i < 8; i++){
        
        dat[0] = dat[0] << 1;
        dat[1] = dat[1] << 1;
        dat[2] = dat[2] << 1;
        
        if(((data[0] >> i) & 0x01) == 0x01){dat[0] |= 0x01;}
        if(((data[1] >> i) & 0x01) == 0x01){dat[1] |= 0x01;}
        if(((data[2] >> i) & 0x01) == 0x01){dat[2] |= 0x01;}
    }
    
    // parity calculate
    for(uint8_t c=0; c < 8; c+=2){
        wk1 += ((dat[0] >> c) & 0x03);
        wk1 += ((dat[1] >> c) & 0x03);
    }
    wk1 += ((dat[2] >> 6) & 0x02);
    
    wk1 &= 0x03;
    if(wk1 == 0x00){wk1 = 0x03;}
    else if(wk1 == 0x03){wk1 = 0x00;}
    
    wk2 = (dat[2] >> 5) & 0x03;
    
    if(wk1 ==  wk2){
        // parity ok
        ans =true;
        honyBee->count++;
        honyBee->band = (dat[0] >> 2) & 0x03;
        honyBee->slottle = ((dat[0] << 2) & 0x0c) | ((dat[1] >> 6) & 0x03);
        honyBee->trim = (dat[1] >> 2) & 0x0f;
        ladder = ((dat[1] << 1) & 0x06) | ((dat[2] >> 7) & 0x01);
        if(0x04 == (ladder & 0x04)){ladder |= 0xf8;}
        honyBee->ladder = ladder;
    }
    else{
        // parity ng
        // nothing
        ans = false;
        honyBee->band = 0x0F;
    }
    
    return ans;
}


/**
 * Normalize HonyBee data.
 *
 * @param buf Pointer to propo recive data.
 *
 * @param propo normalize propo data.
 *
 * @return receive answer : ture:recive ok   false:recive ng.
 */
bool DecodeHonyBee::normalize(uint8_t *buf, CodecHonyBee::normalizePropo_t *propo) {
    bool ans = false;
    bool decodeCheck =false;
    
    CodecHonyBee::honyBeePropo_t HonyBee;
    decodeCheck = DecodeHonyBee::decode(buf, &HonyBee);
    
    if(decodeCheck == true){
        ans = true;
     
        propo->count++;// = HonyBee.count;
        
        switch(HonyBee.band){
        case CodecHonyBee::BAND_A:
            propo->band = 1;
            break;
        case CodecHonyBee::BAND_B:
            propo->band = 2;
            break;
        case CodecHonyBee::BAND_C:
            propo->band = 3;
            break;
        default:
            propo->band = 0;
            break;
        }
        
        if(HonyBee.slottle > CodecHonyBee::SLOTTLE_MAX){HonyBee.slottle = CodecHonyBee::SLOTTLE_MAX;}
        propo->slottle = (float)HonyBee.slottle / CodecHonyBee::SLOTTLE_MAX;
        
        if(HonyBee.ladder >= 0){
            if(HonyBee.ladder > CodecHonyBee::LADDER_MAX){HonyBee.ladder = CodecHonyBee::LADDER_MAX;}
            propo->ladder = (float)HonyBee.ladder / CodecHonyBee::LADDER_MAX;
        }
        else{
            if(HonyBee.ladder < CodecHonyBee::LADDER_MIN){HonyBee.ladder = CodecHonyBee::LADDER_MIN;}        
            propo->ladder = -((float)HonyBee.ladder / CodecHonyBee::LADDER_MIN);
        }

#if 0 // not use        
        if(HonyBee.elevator >= 0){
            if(HonyBee.elevator > CodecHonyBee::ELEVATOR_MAX){HonyBee.elevator = CodecHonyBee::ELEVATOR_MAX;}       
            propo->elevator = (float)HonyBee.elevator / CodecHonyBee::ELEVATOR_MAX;
        }
        else{
            if(HonyBee.elevator < CodecHonyBee::ELEVATOR_MIN){HonyBee.elevator = CodecHonyBee::ELEVATOR_MIN;}
            propo->elevator = -((float)HonyBee.elevator / CodecHonyBee::ELEVATOR_MIN);
        }
#endif // not use
        
        switch (HonyBee.trim){
        case CodecHonyBee::TRIM_LEFT:
            propo->trim = -1.0;
            break;
        case CodecHonyBee::TRIM_RIGHT:
            propo->trim = 1.0;
            break;
        default:
//      case CodecHonyBee::TRIM_NEUTRAL:
            propo->trim = 0.0;
            break;        
        }
  
    }
    else{
        // NG
        ans = false;
    }

    return ans;
}



