/**
 * Codec IR Propo of HonyBee common class
 * Version 0.0  130623
 *
 * Writer:suupen
 */

#ifndef _CODECHonyBee_H_
#define _CODECHonyBee_H_

#include <mbed.h>



class CodecHonyBee {
public:

    typedef struct{
        uint8_t count;
        uint8_t band;   // 1 to 255
        float slottle;  // 0(min) to 1.0(max)
        float ladder;   // -1.0(Left) to 1.0(Right)
        float elevator;  // not use (-1.0(backward) to 1.0(forward))
        float trim;     // -1.0 to 1.0
    } normalizePropo_t;



    typedef struct{
        uint8_t count;      // recive count [1/1 [recive]/count]
        uint8_t band;       // 0x0a:A band  0x0b:B 0x0c:C
        uint8_t slottle;    // 0x00:0 - 0x0e:14
        uint8_t trim;      // 0x0f:Left 0x01:Right 0x00:neutral
        int8_t ladder;      // -3:Left3 -2:Left2 -1:Left1 0:Neutral 1:Right1 2:Right2 3:Right3
        } honyBeePropo_t;


static const uint8_t BAND_A = 0x00;
static const uint8_t BAND_B = 0x01;
static const uint8_t BAND_C = 0x02;

static const uint8_t SLOTTLE_MIN = 0x00;
static const uint8_t SLOTTLE_MAX = 0x0e;

//static const int8_t TRIM_MIN = 0;
//static const int8_t TRIM_MAX = 0x0f;
static const int8_t TRIM_LEFT = 15;
static const int8_t TRIM_RIGHT = 1;
static const int8_t TRIM_NEUTRAL = 0;

static const int8_t LADDER_MIN = -3;
static const int8_t LADDER_MAX = 3;

#if 0 // not use
static const int8_t ELEVATOR_MIN = -15;
static const int8_t ELEVATOR_MAX = 15;
#endif

private:
    
 CodecHonyBee();


};

#endif






