/**********************************************************

*    EightDotMatrixLed.cpp
*    dynamic control of eight dot matrix led
*
**********************************************************/
#define _EIGHTDOTMATRIXLED_C

#include "types.h"
#include "mbed.h"
#include "EightDotMatrixLed.h"




/** Create a eight dot matrix led object connected to the specified DigtalOutput pin
 */
EightDotMatrixLed::EightDotMatrixLed(uint8_t commonPole,
                         PinName seg_a, PinName seg_b, PinName seg_c, PinName seg_d, PinName seg_e, PinName seg_f, PinName seg_g, PinName seg_h,
                         PinName com_1, PinName com_2, PinName com_3, PinName com_4, PinName com_5, PinName com_6, PinName com_7, PinName com_8):
    _seg_a(seg_a), _seg_b(seg_b), _seg_c(seg_c), _seg_d(seg_d), _seg_e(seg_e), _seg_f(seg_f), _seg_g(seg_g), _seg_h(seg_h),
    _com_1(com_1), _com_2(com_2), _com_3(com_3), _com_4(com_4), _com_5(com_5), _com_6(com_6), _com_7(com_7), _com_8(com_8){

    
    timer.attach_us(this, &EightDotMatrixLed::segmentGrayDataKosin, 10000);       // led smooth control 10ms timer inttruupt
    
    // data table set of Brightness
    // DT_pwmGray[] = i ^ 2
    for(uint32_t i = 0; i < Z_grayMax + 1; i++){
        DT_pwmGray[i] = (uint8_t)(((i * i) * Z_pwmGrayMax ) / (Z_grayMax * Z_grayMax));
    }
    
    // check connect com_x
    D_comNull = Z_comSuu;
    if(com_8 == NC){D_comNull--;}
    if(com_7 == NC){D_comNull--;}
    if(com_6 == NC){D_comNull--;}
    if(com_5 == NC){D_comNull--;}
    if(com_4 == NC){D_comNull--;}
    if(com_3 == NC){D_comNull--;}
    if(com_2 == NC){D_comNull--;}
    if(com_1 == NC){D_comNull--;}
    
 
    
    // common and segment pin display data set
    if(commonPole == 0){
        // Anode common
        D_commonOn   = 1;
        D_commonOff  = 0;
        D_segmentOn  = 0;
        D_segmentOff = 1;
    }
    else{
        // Cathod common
        D_commonOn   = 0;
        D_commonOff  = 1;
        D_segmentOn  = 1;
        D_segmentOff = 0;
    }
    
}

    

/**************************************
* 7segment no gray data kosin
* 100ms goto no syori
**************************************/
void EightDotMatrixLed::segmentGrayDataKosin(void){
    uint8_t com;
    uint8_t seg;
    
    for(com = 0; com < Z_comSuu; com++){
        for(seg = 0; seg < Z_segSuu; seg++){
            uint8_t D_dotGrayData = *(A_dotGrayData + (com * Z_segSuu) + seg);
            uint8_t D_dotDigitalData = *(A_dotDigitalData + (com * Z_segSuu) + seg);
            
            if((D_dotGrayData <= 100) && (D_dotDigitalData <= 1)){
                // gray and digital data enable
                if(D_dotDigitalData == 1){
                    if(D_dotPwmData[com][seg] < D_dotGrayData){
                        D_dotPwmData[com][seg]++;
                    }
                }
                else if(D_dotPwmData[com][seg] > 0){
                   D_dotPwmData[com][seg]--;
                }
            }  
            else if((D_dotGrayData > 100) && (D_dotDigitalData <= 1)){
                // gray data disable and digital data enable
                if(D_dotDigitalData == 1){
                    // digital data on
                     if(D_dotPwmData[com][seg] < Z_grayMax){
                        D_dotPwmData[com][seg]++;
                     }
                }     
                else{
                    // digital data off
                     if(D_dotPwmData[com][seg] > 0){
                        D_dotPwmData[com][seg]--;
                     }
                }
            }
            else if((D_dotGrayData <= 100) && (D_dotDigitalData > 1)){
                // gray data enable and digital data disable
                D_dotPwmData[com][seg] = D_dotGrayData;
            }
            else{
                // gray data and digital data disable
                D_dotPwmData[com][seg] = 0;
            }
        }
    }
}


/**************************************
* main
**************************************/
void EightDotMatrixLed::EightDotMatrixLed_main(uint8_t* grayData, uint8_t* digitalData) {
    
    A_dotGrayData = grayData;
    A_dotDigitalData = digitalData;
/*    
    for(uint8_t com = 0; com < 8; com++){
        for(uint8_t seg = 0; seg < 8; seg++){
            D_dotGrayData[com][seg] = *(grayData + (com * Z_segSuu) + seg);
            D_dotDigitalData[com][seg] = *(digitalData + (com * Z_segSuu) +seg);
        }
    }
*/
        // dynamic shuturyoku shori
        output();
}


/**************************************
* comAllClear
*
* common pin o subete OFF suru
**************************************/
void EightDotMatrixLed::comAllClear(void){
    
    switch (D_comNull){
    case 8:                 // com_1 - com_8is all connect
        _com_8 = D_commonOff;
        //break;
    case 7:                 // com_8 Null
        _com_7 = D_commonOff;
        //break;
    case 6:                 // com_7 Null
        _com_6 = D_commonOff;
        //break;
    case 5:                 // com_6 Null
        _com_5 = D_commonOff;
        //break;
    case 4:                 // com_5 Null
        _com_4 = D_commonOff;
        //break;                                
    case 3:                 // com_4 Null
        _com_3 = D_commonOff;
        // break;
    case 2:                 // com_3 Null
        _com_2 = D_commonOff;
        //break;
    case 1:                 // com_2 Null
        _com_1 = D_commonOff;
        //break;
    case 0:                 // com_1 Null
        // nothing
        break;
    default:
        // nothing
        break;
    }
}

/**************************************
* segAllClear
*
* segment pin o subete OFF suru
**************************************/
void EightDotMatrixLed::segAllClear(void){
    _seg_a = D_segmentOff;
    _seg_b = D_segmentOff;
    _seg_c = D_segmentOff;
    _seg_d = D_segmentOff;
    _seg_e = D_segmentOff;
    _seg_f = D_segmentOff;
    _seg_h = D_segmentOff;
}

/**************************************
* segDataSet
*
* segment pin ni shuturyoku data o settei
**************************************/
void EightDotMatrixLed::segDataSet(uint8_t keta){

    for(uint8_t i = 0; i < Z_pwmGrayMax + 1; i++){
        if(DT_pwmGray[D_dotPwmData[keta][0]] <= i){_seg_a = D_segmentOff;}else{_seg_a = D_segmentOn;}
        if(DT_pwmGray[D_dotPwmData[keta][1]] <= i){_seg_b = D_segmentOff;}else{_seg_b = D_segmentOn;}
        if(DT_pwmGray[D_dotPwmData[keta][2]] <= i){_seg_c = D_segmentOff;}else{_seg_c = D_segmentOn;}
        if(DT_pwmGray[D_dotPwmData[keta][3]] <= i){_seg_d = D_segmentOff;}else{_seg_d = D_segmentOn;}
        if(DT_pwmGray[D_dotPwmData[keta][4]] <= i){_seg_e = D_segmentOff;}else{_seg_e = D_segmentOn;}
        if(DT_pwmGray[D_dotPwmData[keta][5]] <= i){_seg_f = D_segmentOff;}else{_seg_f = D_segmentOn;}
        if(DT_pwmGray[D_dotPwmData[keta][6]] <= i){_seg_g = D_segmentOff;}else{_seg_g = D_segmentOn;}
        if(DT_pwmGray[D_dotPwmData[keta][7]] <= i){_seg_h = D_segmentOff;}else{_seg_h = D_segmentOn;}
    
    }
}

/**************************************
* output
*
* dynamic dosa saseru.
* kono kansu wo jiikou suru tabi ni common pin o kirikaeru
**************************************/
void EightDotMatrixLed::output(void){
    static uint8_t M_seg = 0;

    if(M_seg >= D_comNull){M_seg = 0;}

    // com, seg syokika
    comAllClear();
    segAllClear();
    
 

    // common output
    if(D_comNull != 0){
        // If the terminal output processing
        switch(M_seg){
        case 0:
            _com_1 = D_commonOn;
            break;
        case 1:
            _com_2 = D_commonOn;
            break;
        case 2:
            _com_3 = D_commonOn;
            break;
        case 3:
            _com_4 = D_commonOn;
            break;
        case 4:
            _com_5 = D_commonOn;
            break;
        case 5:
            _com_6 = D_commonOn;
            break;                    
        case 6:
            _com_7 = D_commonOn;
            break;                    
        case 7:
            _com_8 = D_commonOn;
            break;                                                
        default:
            break;
        }
    }
    
    // segmant output
    if(M_seg < Z_comSuu){
        segDataSet(M_seg);
    }


    // com, seg syokika
    comAllClear();
    segAllClear();
    M_seg++;
}
