/**
 * digital Sw Library
 */

#include "DigitalSw.h"

/**
 *
 */
DigitalSw::DigitalSw(PinName sw, uint8_t pull
                    ) : _sw(sw), _pull(pull)
{

    _onEdge = 0;
    _offEdge = 0;
    _levelNow = 1;
    _levelOld = 1;

    if(_pull == 1) {
        _sw.mode(PullUp);
    } else {
        _sw.mode(PullDown);
    }
    
    _sw.rise(this, &DigitalSw::swLevelUp);
    _sw.fall(this, &DigitalSw::swLevelDown);


}

void DigitalSw::reset(void)
{
    _onEdge = 0;
    _offEdge = 0;
    _levelNow = 1;
    _levelOld = 1;
}

int16_t DigitalSw::getLevel(void)
{
    return !_levelNow;
}

int16_t DigitalSw::getOnEdge(void)
{
    int16_t ans = _onEdge;
    _onEdge = 0;

    return ans;
}

int16_t DigitalSw::getOffEdge(void)
{
    int16_t ans = _offEdge;
    _offEdge = 0;

    return ans;
}



void DigitalSw::swLevelUp(void)
{
    uint8_t levelCheck = 0xaa;

    while((levelCheck != 0x00) && (levelCheck != 0xff)) {
        wait_us(100);
        levelCheck = (levelCheck << 1) | _sw.read();
    }

    if(levelCheck == 0xff) {
        _levelOld = _levelNow;
        _levelNow = 1;


        if(_levelOld == 0) {
            _offEdge |= 1;
        }
    }
}

void DigitalSw::swLevelDown(void)
{
    uint8_t levelCheck = 0xaa;

    while((levelCheck != 0x00) && (levelCheck != 0xff)) {
        wait_us(100);
        levelCheck = (levelCheck << 1) | _sw.read();
    }

    if(levelCheck == 0x00) {
        _levelOld = _levelNow;
        _levelNow = 0;


        if(_levelOld == 1) {
            _onEdge |= 1;
        }
    }
}

