/**********************************************************

*    DcMotorDirectDrive.cpp
*    Dc motor direct drive library
*
**********************************************************/
#define _DCMOTORDIRECTDRIVE_C

#include "types.h"
#include "mbed.h"
#include "DcMotorDirectDrive.h"




/** DC motor direct drive object connected to the specified DigtalOutput pin
 */
DcMotorDirectDrive::DcMotorDirectDrive(PinName pwmPin, PinName referencePin) :
 _pwmPin(pwmPin), _referencePin(referencePin){
 
    // pwm setting
    _referencePin = 0;
    _pwmPin.period_us(Z_pwmPeriod);  // pwm period 0.1[ms](10[kHz])
    _pwmPin.write(0.0);
        
}

    


/**************************************
* main
**************************************/
void DcMotorDirectDrive::DcMotorDirectDrive_main(float request) {
    if(request > Z_stopRange){
        // normal rotation
        _referencePin = 0;
        _pwmPin.write(request);
    }
    else if(request < -Z_stopRange){
        // reversal rotation
        _referencePin = 1;
        _pwmPin.write(1.0f + request);
        
    }
    else{
        // stop
        _referencePin = 0;
        _pwmPin.write(0.0);        
    }   
 
}


