//============================================
// DcMotorDirectDrive Library Example
//
// This program controls the motor 3.
// Repeat the forward and reverse motor.
// Continuously varies the rotational speed of the motor.
//
// <schematic>
//
//                                   motor1,2,3 : mabuchi motor RF-300C-11440  DC3V 18mA 2200rpm)
//                              __
//    p21(pwmOut)     ---------|  |  motor1
//                             |  |--
//    p22(digitalOut) ---------|__|
//
//                              __
//    p23(pwmOut)     ---------|  |  motor2
//                             |  |--
//    p24(digitalOut) ---------|__|
//
//                              __
//    p25(pwmOut)     ---------|  |  motor3
//                             |  |--
//    p26(digitalOut) ---------|__|
//
//=============================================

#include "mbed.h"

#include "DcMotorDirectDrive.h"

//                          pwm pin
//                          |  
//                          |    reference pin                          
//                          |    |
DcMotorDirectDrive motor1(p21, p22);
DcMotorDirectDrive motor2(p23, p24);
DcMotorDirectDrive motor3(p25, p26);


DigitalOut led1(LED1);
DigitalOut led4(LED4);

Timer timer;    // data change timer
    
int main() {
    float siji = 1.0f;  // motor output (+1.0 -> ... -> +0.5 -> -1.0 -> ... -> -0.5 -> +1.0)
    uint8_t fugo = 0;   // 0 : normal rotation,  1 : reverse rotation
    
    
    timer.start();

    while(1) {
        // After 100[ms] to start the process
        if(timer.read_ms() >= 100){
            timer.reset();
            
            if(fugo == 0){
                // Normal rotation
                // siji = +1.0 -> +0.5 
                 siji -= 0.005;
                if(siji < 0.5f){
                    fugo = 1;
                    siji = -1.0f;
                }
            }
            else{
                // Reverse rotation
                siji += 0.005;
                if(siji > -0.5f){
                    fugo = 0;
                    siji = +1.0f;
                }
           }
            // Outputs a control instruction to the motor
            motor1.DcMotorDirectDrive_main(siji);           
            motor2.DcMotorDirectDrive_main(siji);
            motor3.DcMotorDirectDrive_main(siji);
        
            // rotation display
            if(siji > 0.5){
                // normal rotation
                led1 = 1;
                led4 = 0;
            }
            else{
                // reverse rotation
                led1 = 0;
             led4 = 1;        
            }
        }
    }
}
