/**
 * Codec IR Propo of Swift common class
 * Version 0.0      130623
 *
 * Writer:suupen
 */

#ifndef _CODECSWIFT_H_
#define _CODECSWIFT_H_

#include <mbed.h>



class CodecSwift {
public:

    typedef struct{
        uint8_t count;
        uint8_t band;   // 1 to 255
        float slottle;  // 0(min) to 1.0(max)
        float ladder;   // -1.0(Left) to 1.0(Right)
        float elevator;  // -1.0(backward) to 1.0(forward)
        float trim;     // -1.0 to 1.0
    } normalizePropo_t;



    typedef struct{
        uint8_t count;      // recive count [1/1 [recive]/count]
        uint8_t band;       // 0x03:A band  0x02:B 0x01:C
        uint8_t slottle;    // 0x00 - 0x72
        int8_t trim;      //  -23 to 29
        int8_t ladder;      // right:1 to 15,  left:-1 to -15
        int8_t elevator;    // forward: 1 to 15 , backward -1 to -15
    } swiftPropo_t;

static const uint8_t BAND_A = 0x03;
static const uint8_t BAND_B = 0x02;
static const uint8_t BAND_C = 0x01;

static const uint8_t SLOTTLE_MIN = 0x00;
static const uint8_t SLOTTLE_MAX = 114;

static const int8_t TRIM_MIN = -23;
static const int8_t TRIM_MAX = 23;

static const int8_t LADDER_MIN = -15;
static const int8_t LADDER_MAX = 15;

static const int8_t ELEVATOR_MIN = -15;
static const int8_t ELEVATOR_MAX = 15;


private:
    
 CodecSwift();


};

#endif






