/**
 * IR Propo Decode class
 *  Version 0.0     130623
 *
 * Writer:suupen
 */
 #include "CodecSwift.h"
 #include "DecodeSwift.h"
 
 /**
 * Constructor DecodeSwift
 *
 */
 DecodeSwift::DecodeSwift(){
    // nothing
 }
 
 /**
 * Destructor.
 */
 DecodeSwift::~DecodeSwift(){
    // nothing
 }
 

/**
 * Get swift controller data.
 *
 * @param data Pointer to propo recive data.
 *
 * @param swift Pointer to swift.
 *
 * @return receive answer : ture:recive ok   false:recive ng.
 */
bool DecodeSwift::decode(uint8_t *data, CodecSwift::swiftPropo_t *swift) {
    bool ans = false;
    int8_t wk1 = 0;
    int8_t wk2;
    
    int8_t wk3;
    int8_t trimWork;
    
    // parity calculate
   
    for(uint8_t c=0; c < 3; c++){
        wk1 += data[c] & 0x3f;
    }
    if(0 != (wk1 & 0x0f)){
        wk1 = wk1 + 0x10 - 0x01;
    }
    else{
        wk1 |= 0x0f;
    }
    
    wk1 &= 0x3f;    
    wk2 = data[3] & 0x3f;
    if(wk1 ==  wk2){
        // parity ok
        ans =true;
        swift->count++;      // recive count [1/1 [recive]/count]
        swift->band = (data[3] >> 6 ) & 0x03;        // 0x03:A band  0x02:B 0x01:C
        swift->slottle = data[0] & 0x7f;    // 0x00 - 0x72
        
        trimWork = data[2] & 0x1F;
        if((data[2] & 0x20) == 0x20){
            trimWork = -trimWork;
        }
        else{
            // nothine
        }
        swift->trim = trimWork;
        
        // right:1 to 15,  left:-1 to -15
        wk3 = (data[1] >> 4) & 0x0f;
        if(0x80 == (data[2] & 0x80)){
            swift->ladder = wk3;
        }
        else{
            swift->ladder = -wk3;
        }
  
        // forward: 1 to 15 , backward -1 to -15
        wk3 = (data[1] & 0x0f);
        if(0x40 == (data[2] & 0x40)){
            swift->elevator = wk3;
        }
        else{
            swift->elevator = -wk3;
        }
    }
    else{
        // parity ng
        
        ans = false;
    }
     

    return ans;

}


/**
 * Normalize Swift data.
 *
 * @param buf Pointer to propo recive data.
 *
 * @param propo normalize propo data.
 *
 * @return receive answer : ture:recive ok   false:recive ng.
 */
bool DecodeSwift::normalize(uint8_t *buf, CodecSwift::normalizePropo_t *propo) {
    bool ans = false;
    bool decodeCheck =false;
    
    CodecSwift::swiftPropo_t swift;
    decodeCheck = DecodeSwift::decode(buf, &swift);
    
    if(decodeCheck == true){
        ans = true;
     
        propo->count++;// = swift.count;
        
        switch(swift.band){
        case CodecSwift::BAND_A:
            propo->band = 1;
            break;
        case CodecSwift::BAND_B:
            propo->band = 2;
            break;
        case CodecSwift::BAND_C:
            propo->band = 3;
            break;
        default:
            propo->band = 0;
            break;
        }
        
        if(swift.slottle > CodecSwift::SLOTTLE_MAX){swift.slottle = CodecSwift::SLOTTLE_MAX;}
        propo->slottle = (float)swift.slottle / CodecSwift::SLOTTLE_MAX;
        
        if(swift.ladder >= 0){
            if(swift.ladder > CodecSwift::LADDER_MAX){swift.ladder = CodecSwift::LADDER_MAX;}
            propo->ladder = (float)swift.ladder / CodecSwift::LADDER_MAX;
        }
        else{
            if(swift.ladder < CodecSwift::LADDER_MIN){swift.ladder = CodecSwift::LADDER_MIN;}        
            propo->ladder = -((float)swift.ladder / CodecSwift::LADDER_MIN);
        }
        
        if(swift.elevator >= 0){
            if(swift.elevator > CodecSwift::ELEVATOR_MAX){swift.elevator = CodecSwift::ELEVATOR_MAX;}       
            propo->elevator = (float)swift.elevator / CodecSwift::ELEVATOR_MAX;
        }
        else{
            if(swift.elevator < CodecSwift::ELEVATOR_MIN){swift.elevator = CodecSwift::ELEVATOR_MIN;}
            propo->elevator = -((float)swift.elevator / CodecSwift::ELEVATOR_MIN);
        }
        
        if(swift.trim >=0 ){
            if(swift.trim > CodecSwift::TRIM_MAX){swift.trim = CodecSwift::TRIM_MAX;}
            propo->trim = (float)swift.trim / CodecSwift::TRIM_MAX;
        }
        else{
            if(swift.trim < CodecSwift::TRIM_MIN){swift.trim = CodecSwift::TRIM_MIN;}
            propo->trim = -((float)swift.trim / CodecSwift::TRIM_MIN);
        }
    }
    else{
        // NG
        ans = false;
    }

    return ans;
}



