/**
 * Decode IR Propo Swift class
 *  Version 0.0     130623
 *
 * Writer:suupen
 */

#ifndef _DECODESWIFT_H_
#define _DECODESWIFT_H_

#include <mbed.h>
#include "CodecSwift.h"


/**
 * Decode class.
 */
class DecodeSwift {
public:


/**
 * Constructor
 */
  DecodeSwift();
  
/**
 * Destructor.
 */
  ~DecodeSwift();
    
/**
 * Get swift propo analysis data.
 *
 * @param data IR recive data
 *
 * @param swift Pointer to swift.
 *
 * @return receive answer : ture:recive ok   false:recive ng.
 */
    bool decode(uint8_t *data, CodecSwift::swiftPropo_t *swift);

/**
 * Normalize Swift data.
 *
 * @param buf Pointer to propo recive data.
 *
 * @param propo normalize propo data.
 *
 * @return receive answer : ture:recive ok   false:recive ng.
 */
bool normalize(uint8_t *buf, CodecSwift::normalizePropo_t *propo);

private:
    
 


};

#endif


