#include "stdio.h"
#include "stdlib.h"
#include "math.h"
#include "mbed.h"
#include "ST7735_TFT.h"
#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"

#define NUMBER_OF_STARS 300
#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 160

/*star struct*/
typedef struct {
    float xpos, ypos;
    short zpos, speed;
    unsigned int color;
} STAR;

static STAR stars[NUMBER_OF_STARS];


void init_star(STAR* star, int i)
{
    /* randomly init stars, generate them around the center of the screen */

    star->xpos =  -10.0 + (20.0 * (rand()/(RAND_MAX+1.0)));
    star->ypos =  -10.0 + (20.0 * (rand()/(RAND_MAX+1.0)));

    star->xpos *= 3072.0; /*change viewpoint */
    star->ypos *= 3072.0;

    star->zpos =  i;
    star->speed =  2 + (int)(2.0 * (rand()/(RAND_MAX+1.0)));

    star->color = i*Cyan >> 2; /*the closer to the viewer the brighter*/
}


void init()
{
    int i;

    for (i = 0; i < NUMBER_OF_STARS; i++) {
        init_star(stars + i, i + 1);
    }
}


// the TFT is connected to SPI pin 5-7, CS is p8, RS is p11, reset is p15
ST7735_TFT TFT(p5, p6, p7, p8, p11, p15,"TFT"); // mosi, miso, sclk, cs, rs, reset

Serial pc(USBTX, USBRX); // tx, rx
Timer t;

extern unsigned char p1[];  // the mbed logo

int main()
{

    unsigned int centerx, centery;
    int i, j, tempx, tempy;
    init();
    TFT.set_orientation(1); // original = 1
    centerx = TFT.width() >> 1;
    centery = TFT.height() >> 1;


    TFT.claim(stdout);      // send stdout to the TFT display
    //TFT.claim(stderr);      // send stderr to the TFT display

    TFT.background(Black);    // set background to black

    TFT.foreground(White);    // set chars to white

    TFT.cls();
    TFT.set_font((unsigned char*) Arial24x23);  // select the font

    t.start();


//↓@ss demo
        for( i=0; i < 1000; i++){
          TFT.circle(rand()%TFT.width(), rand()%TFT.height(), rand()%50, rand()%0xffff);
          }
          
          for( i=0; i < 10000; i++){
          TFT.rect(rand()%TFT.width(), rand()%TFT.height(), rand()%TFT.width(), rand()%TFT.height(), rand()%0xffff);
          }
          
          for( i=0; i < 1000; i++){
          TFT.fillcircle(rand()%TFT.width(), rand()%TFT.height(), rand()%50, rand()%0xffff);
          
                    for( i=0; i < 1000; i++){
          TFT.fillrect(rand()%TFT.width(), rand()%TFT.height(), rand()%TFT.width(), rand()%TFT.height(), rand()%0xffff);
          }
          
          
          }
//↑@ss demo


    ////// demo start
    // ***************************************************************
        for( j = 0 ; j < 10000; j++)
    //    for ( j = 0 ; j < 10000; j++ )
        {


          // move and draw stars

          for (i = 0; i < NUMBER_OF_STARS; i++)
        {
          tempx = (stars[i].xpos / stars[i].zpos) + centerx;
          tempy = (stars[i].ypos / stars[i].zpos) + centery;
          TFT.pixel(tempx,tempy,Black);


          stars[i].zpos -= stars[i].speed;

          if (stars[i].zpos <= 0)
            {
              init_star(stars + i, i + 1);
            }

          //compute 3D position
          tempx = (stars[i].xpos / stars[i].zpos) + centerx;
          tempy = (stars[i].ypos / stars[i].zpos) + centery;

          if (tempx < 0 || tempx > TFT.width() - 1 || tempy < 0 || tempy > TFT.height() - 1) //check if a star leaves the screen
            {
              init_star(stars + i, i + 1);
              continue;
            }

          TFT.pixel(tempx,tempy,stars[i].color);

        }
         TFT.Bitmap(centerx-60,centery-19,120,38,p1);
        }

        ///// demo stop

        t.stop();
  //  *******************************************************************/


//↓@ss test
#ifndef 1
    TFT.set_font((unsigned char*) Arial12x12);  // select the font
    for(int x = 159; x >= 0; x--) {
//    TFT.pixel(-2,-1,0x100*x+0xff);
        TFT.rect(0, 0, x,(x-32), 0xffff);
        TFT.locate(0,10);
        printf("X=%d, y = %d",x,x-32);
        wait(0.1);
        TFT.rect(0, 0, x,(x-32), 0x0000);
    }
#else
//    TFT.locate(0,10);
    TFT.set_font((unsigned char*) Arial12x12);  // select the font
//    printf("Time %f s\n", t.read());

//   TFT.fillrect(-2, -1, 157, 126, 0);  //clr

    TFT.set_font((unsigned char*) Arial12x12);
    /*
        TFT.rect(0,0,159,127,0xffff);
        TFT.rect(10,10,20,20,0x0fff);
        TFT.rect(158,126,20,20,0xffff);
        TFT.line(0,0, 159,127,0xffff);
        TFT.line(159,0,0,127,0xffff);
    */
    for(int y = 0; y < 128; y+=1) {
        for(int x = 0; x <160; x+=1) {
            if(y%2== 0) {
                if(x%2==0) {
                    TFT.pixel(x,y,0xffff);
                } else {
                    TFT.pixel(x,y,0x0ff);
                }
            } else {
                if(x%2==0) {
                    TFT.pixel(x,y,0xff);
                } else {
                    TFT.pixel(x,y,0xffff);
                }
            }
            //wait_ms(10);
        }
    }

#endif
//↑@ss test

}