/**************************************
* Akizuki Geiger Kit                
*
* program ver 0.1 2001/03/31
*
* Text Lcd
*   RS  : p8
*   E   : p9
*   WR  : P14   (output=Low(GND))
*   d4  : p13
*   d5  : p10
*   d6  : p12
*   d7  : p11
*
* Akizuki Geiger
*   signal      : p24 (Akizuki Geiger Kit no "EX Out" kara 1:3 no teikou bunatu de 9[V] wo 3[V] ni site nyuuryoku) 
*   signalGnd   : p21(output=Low(GND))
*
* sanko bunken
*   maikon to densi kosaku No.5
*       CQ shupansha
**************************************/

#include "mbed.h"
#include "TextLCD.h"
#include "EthernetNetIf.h"
#include "NTPClient.h"
#include "HTTPClient.h"

#define TMP_TEXT_BUF_SIZE (256)   // mojiretu yo buffer size

enum hyojisaki_t{
    lcd_hyoji,
    twitter_hyoji
    };

// Ethernet
EthernetNetIf eth; 
NTPClient ntp;

// File access
LocalFileSystem local("local");


// Text LCD
DigitalOut RW(p14);
TextLCD lcd(p8, p9, p13, p10, p12, p11, TextLCD::LCD20x4); // rs, e, d4-d7

DigitalOut BackLight(p22);

// Geiger
DigitalOut Geiger_GND(p21); // Geiger signal Gnd
InterruptIn Geiger_signal(p24); // Geiger signal


// sokutei chi
unsigned int C_geiger = 0;
unsigned int C_geigerMin[6]  = {0, 0, 0, 0, 0, 0};
unsigned int C_geigerHour[6] = {0, 0, 0, 0, 0, 0};

// sokutei chi no kakunou pointer
unsigned char P_geigerMin  = 5;      // C_geigerMin  no Pointer  0-5
unsigned char P_geigerHour = 5;     // C_geigerHour no Pointer  0-5

// Twitter
char id[32] = "\0";
char password[32] = "\0";

/***********************************
* File access
*
* Text file kara 1gyo bun wo syutoku
***********************************/
unsigned char GetFileLine(FILE *stm, char *str){
    char count = 0;
    
    if(fread(&str[count], 1, 1, stm) > 0){
        count++;
        while((fread(&str[count], 1, 1, stm) > 0)
                &&(str[count] != '\n')
                &&(count < TMP_TEXT_BUF_SIZE)){
                    count++;
        }
    }
    str[count] = '\n';
    return(count);
}

/***********************************
* tag kara mojiretu wo syutoku
***********************************/
int GetStatus(char *path, char *tag, char *text){
    char *TmpText = (char*)malloc(TMP_TEXT_BUF_SIZE);
    
    if(TmpText == NULL){
        return (-1);
    }

    char *TmpTag = (char*)malloc(TMP_TEXT_BUF_SIZE);
    
    if(TmpTag == NULL){
        free(TmpTag);
        return(-1);
    }
    
    FILE *stm = fopen(path, "r");
    
    if(stm != NULL){
        text[0] = '\0';
        sprintf(TmpTag, "%s:%%s",tag);
        
        while(GetFileLine(stm, TmpText) > 0){
            sscanf(TmpText, TmpTag, text);
        }
        fclose(stm);
    }    
    
    free(TmpText);
    free(TmpTag);
    
    return(0);
}


/***********************************
* Twitter
***********************************/
void TwitMsg(char *msg){
    HTTPClient twitter;
    HTTPMap h_msg;
  h_msg["status"] = msg; //A good example of Key/Value pair use with Web APIs

  twitter.basicAuth(id, password); //We use basic authentication, replace with you account's parameters
  
  //No need to retieve data sent back by the server
  HTTPResult r = twitter.post("http://api.supertweet.net/1/statuses/update.xml", h_msg, NULL); 
  if( r == HTTP_OK )
  {
    printf("Tweet sent with success!\n");
  }
  else
  {
    printf("Problem during tweeting, return code %d\n", r);
  }
}

/**************************************
* 10Fun Count data no hyoji sakusei
***************************************/
void geiger_10FunHyoji(char *msg, hyojisaki_t hyoji){
    char tmp[5] = "\0";
    signed char i;
    signed char p;
    
    //strcat(msg, "M:");
    
    for(i = 0; i <= 5; i++){
        p = P_geigerMin - i;
        if(p < 0){
            p += 6;
        }
        switch(hyoji){
        case lcd_hyoji:
            sprintf(tmp, "%3d",C_geigerMin[p]);
            break;
        case twitter_hyoji:
        default:
            sprintf(tmp, "%3d ",C_geigerMin[p]);
            break;
        }
 
        strcat(msg, tmp);
    }
}

/**************************************
* 1Jikan Count data no hyoji sakusei
***************************************/
void geiger_1JikanHyoji(char *msg, hyojisaki_t hyoji){
    char tmp[4] = "\0";
    signed char i;
    signed char p;
    
    //strcat(msg, "H:");
    
    for(i = 0; i <= 5; i++){
        p = P_geigerHour - i;
        if(p < 0){
            p += 6;
        }
        switch(hyoji){
        case lcd_hyoji:
            sprintf(tmp, "%3d",C_geigerHour[p]);
            break;
        case twitter_hyoji:
        default:
            sprintf(tmp, "%3d ",C_geigerHour[p]);
            break;
        }
 
        strcat(msg, tmp);
    }
}

/**************************************
* calendar hyoji
***************************************/
void calendarHyoji(char *msg){
    time_t ctTime;
    struct tm *jst_time;
    char tmp[21] = "\0";
    
    ctTime = time(NULL);
    ctTime += 32400;
    jst_time = localtime(&ctTime);
    
    sprintf(tmp,"%4d/%02d/%02d %02d:%02d:%02d",(jst_time->tm_year + 1900),(jst_time->tm_mon + 1),jst_time->tm_mday, jst_time->tm_hour, jst_time->tm_min, jst_time->tm_sec);
    strcat(msg, tmp);    
}


/**************************************
* LCD output
*
*   kiokuchi wo LCD ni hyoji
***************************************/
void LCD_output(){
    char msg[21] = "\0";
    
    // calendar
    calendarHyoji(msg);
    lcd.locate(0,0);
    lcd.printf("%s",msg);
    
    // 10 fun no genzai iti
    lcd.locate(0,1);
    lcd.printf("M:");
    msg[0] = '\0';
    geiger_10FunHyoji(msg, lcd_hyoji);
    lcd.locate(2,1);
    lcd.printf("%s",msg);
    
    // 1 jikan no genzai iti
    lcd.locate(0,2);
    lcd.printf("H:");
    msg[0] = '\0';
    geiger_1JikanHyoji(msg, lcd_hyoji);
    lcd.locate(2,2);
    lcd.printf("%s",msg);
 
    // genzai count
    lcd.locate(0,3);
    lcd.printf("genzai = ");
    
    lcd.locate(9,3);
    lcd.printf("%3d",C_geiger);
    
    
}

/**************************************
* Twitter he syuturyoku
*
*   kiokuchi wo LCD ni hyoji
***************************************/
void twitter_output(void){
    char msg[256] = "\0";
    
    // calendar
    calendarHyoji(msg);
    strcat(msg,"\n");

    
    // 10 fun no genzai iti
    strcat(msg,"\n");
    strcat(msg,"10Min/count:");
    geiger_10FunHyoji(msg, twitter_hyoji);
 
    
    // 1 jikan no genzai iti
    strcat(msg,"\n");
    strcat(msg,"1Hour/count:");
    geiger_1JikanHyoji(msg, twitter_hyoji);

    TwitMsg(msg);
    
    
}
/*************************************
* geiger signal input interrupt
*
* geiger counter karano singo wo count
**************************************/
void geiger(){
    C_geiger++;

      
}

/****************************************
* Timer
*
*  10Fun goto no sekisan to 1jikan goto no sekisan
*****************************************/
Ticker timer;

void attime(){
    unsigned char i;
    unsigned int wk = 0;


    
    // 1jikan keika nara 1jikan no sekisan keisan
    P_geigerMin++;
    if(P_geigerMin > 5){
        P_geigerMin = 0;
    }
    
    C_geigerMin[P_geigerMin] = C_geiger;
    C_geiger = 0;
    
    if(P_geigerMin == 5){
        for(i = 0; i < 6; i++){
            wk += C_geigerMin[i];
        }
        P_geigerHour++;
        if(P_geigerHour > 5){
            P_geigerHour = 0;
        }
        C_geigerHour[P_geigerHour] = wk;
  
    }
      
    twitter_output();
}



/************************************
*  main
*
************************************/
int main() {
    /******************************
    * Twitter id password syutoku
    ******************************/
    GetStatus("/local/env.ini","ID",id);
    GetStatus("/local/env.ini","PASS",password);

    printf("%s\n",id);
    printf("%s\n",password);

    /******************************
    * geiger setup
    *******************************/
    // 10Fun syuuki timer interrupt
    timer.attach(&attime, 600);

    Geiger_signal.rise(&geiger);
    Geiger_signal.mode(PullNone);

    /*****************************
    * LCD setup
    *****************************/    
    RW = 0;
    BackLight = 0;
//  lcd.printf("Hello World!\n");

    /**********************************
    * Ethernet setup
    **********************************/
    printf("Start\n");

    printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("Setup OK\r\n");
  
    /*********************************
    * NTP setup
    *********************************/
    time_t ctTime;
    ctTime = time(NULL);  
    printf("Current time is (UTC): %s\n", ctime(&ctTime));  

    Host server(IpAddr(), 123, "0.uk.pool.ntp.org");
    ntp.setTime(server);
    
    ctTime = time(NULL);  
    printf("\nTime is now (UTC): %s\n", ctime(&ctTime)); 



 
    
    
    while(1){

    LCD_output(); 
 
      //  wait(1.0);
    }
}
