/**********************************************************
*    Attention : The comment on this file is written in Japanese. 
*
*    main.cpp
*    dynamic kudou no sample program
*    This is program to control LTC-4627(Seven-Segment Numeric LED Display) with mbed.
*
*    LTC4627(4keta 7segment LED) o dynamic kudou suru. 
*     http://www.excesssolutions.com/mas_assets/acrobat/ES5721.pdf
*    common  shuturyoku wa 5 hon.
*    segment shuturyoku wa 8 hon.
*    1hon no LED niwa 20[mA] nagasu no de teikou ha 165[ohm](165[ohm] = 3.3[V] / 20[mA])o tukau.165[ohm]ni chikai atai no 180[ohm]o tukau.
*         
*
*    LTC4627 to mbed no setuzoku kankei
*    LTC4627                                      R(180[ohm])     mbed
*    PinNo    PinKinou                            (*1)            Pin name (*2)
*     1        Common Anode Digit 1                -                p20
*     2        Common Anode Digit 2                -                p19
*     3        Cathode D                           R                p18
*     4        Common Anode Digit L1,L2,L3         -                p17
*     5        Cathode E                           R                p16
*     6        Common Anode Digit 3                -                p15
*     7        Cathode D.P                         R                p14
*     8        Common Anode Digit 4                -                p13
*     9        No Connection                       -                -
*    10        No Pin                              -                -
*    11        Cathode F                           R                p25
*    12        No Pin                              -                -
*    13        Cathode C, L3                       R                p24
*    14        Cathode A, L1                       R                p23
*    15        Cathode G                           R                p22
*    16        Cathode B, L2                       R                p21
*
*    *1 : "R" no tokoro wa LTC4627 to mbed no aidani teikou o chokuretu ni ireru.
*        "-" wa teikou ha setuzoku sinai.
*    *2 : subete "DigitalOut" 
*
**********************************************************/


#include "mbed.h"

void dynamic_output(void);

// mbed pin no teigi
// common shuturyoku no setttei
DigitalOut com_1(p20);
DigitalOut com_2(p19);
DigitalOut com_3(p15);
DigitalOut com_4(p13);
DigitalOut com_L(p17);  // colon

// segment shuturyoku no settei
DigitalOut seg_a(p23);
DigitalOut seg_b(p21);
DigitalOut seg_c(p24);
DigitalOut seg_d(p18);
DigitalOut seg_e(p16);
DigitalOut seg_f(p25);
DigitalOut seg_g(p22);
DigitalOut seg_p(p14);  // DP

DigitalOut seg_col1(p23);
DigitalOut seg_col2(p21);
DigitalOut seg_col3(p24);

// 7segment no shuturyoku pattern
                          //          seg: a b c d  e f g p
                          //          bit: 7 6 5 4  3 2 1 0
                          //          ---------------------
#define D_0 (0xfc)        // 0             1 1 1 1  1 1 0 0
#define D_1 (0x60)        // 1             0 1 1 0  0 0 0 0
#define D_2 (0xda)        // 2             1 1 0 1  1 0 1 0
#define D_3 (0xf2)        // 3             1 1 1 1  0 0 1 0
#define D_4 (0x66)        // 4             0 1 1 0  0 1 1 0
#define D_5 (0xb6)        // 5             1 0 1 1  0 1 1 0
#define D_6 (0xbe)        // 6             1 0 1 1  1 1 1 0
#define D_7 (0xe4)        // 7             1 1 1 0  0 1 0 0
#define D_8 (0xfe)        // 8             1 1 1 1  1 1 1 0
#define D_9 (0xf6)        // 9             1 1 1 1  0 1 1 0


DigitalOut myled(LED1);    // program dosa kakunin yo LED

unsigned char D_7seg[4];    // 7segment heno shuturyoku data kakunou you hensu
                            // [0]:1000 no kurai   [1]:100 no kurai [2]:10 no kurai [3]:1 no kurai

/**************************************
* main
**************************************/
int main() {
    
    
    int data = 0; // hyoji data (4keta no 7segment LED nanode 0 kara 9999 made hyoji dekiru)

    float count = -1;  // 0 kara hyoji saseru tameni -1 o settei suru

   while(1) {

        // program dosa kakunin yo LED tenmetu
        myled = !myled;
        wait(0.001000);                // while{} o 1kai shori suru jikan o chosei(kokode jikan tubusi)  (Seven segment refresh rate 1ms)    check.1

        // hyoji data no kousin
        count = count + 1.000000;          // while{} o 1kai shori surugoto no kasan su      check.2
        if(count > 9999){count = 0;}    // saidaichi o 9999 ni seigen 
        data = (int)count;
        
        // shuturyoku data no kousin
        D_7seg[0] =  data / 1000;          // 1000 no kurai no data
        D_7seg[1] = (data % 1000) / 100;   //  100 no kurai no data
        D_7seg[2] = (data %  100)  / 10;   //   10 no kurai no data
        D_7seg[3] = (data %   10);         //    1 no kurai no data

        // dynamic shuturyoku shori
        dynamic_output();
    }
}

/**************************************
* dynamic_comAllClear
*
* common pin o subete OFF suru
**************************************/
void dynamic_comAllClear(void){
    com_1 = 0;
    com_2 = 0;
    com_3 = 0;
    com_4 = 0;
    com_L = 0;
}

/**************************************
* dynamic_segAllClear
*
* segment pin o subete OFF suru
**************************************/
void dynamic_segAllClear(void){
    seg_a = 1;
    seg_b = 1;
    seg_c = 1;
    seg_d = 1;
    seg_e = 1;
    seg_f = 1;
    seg_p = 1;
}

/**************************************
* dynamic_segDataSet
*
* segment pin ni shuturyoku data o settei
**************************************/
void dynamic_segDataSet(unsigned char data){
    const unsigned char Z_segData[10] = {D_0, D_1, D_2, D_3, D_4, D_5, D_6, D_7, D_8, D_9,};
    unsigned char work;
    
    work = Z_segData[data];
    
    seg_a = (work & 0x80) ? 0 : 1;
    seg_b = (work & 0x40) ? 0 : 1;
    seg_c = (work & 0x20) ? 0 : 1;
    seg_d = (work & 0x10) ? 0 : 1;
    seg_e = (work & 0x08) ? 0 : 1;
    seg_f = (work & 0x04) ? 0 : 1;
    seg_g = (work & 0x02) ? 0 : 1;
    seg_p = (work & 0x01) ? 0 : 1;
    
}

/**************************************
* dynamic_output
*
* dynamic dosa saseru.
* kono kansu wo jiikou suru tabi ni common pin o kirikaeru
**************************************/
void dynamic_output(void){
    static unsigned char M_seg = 0;
        
    switch(M_seg){
    case 0:                                // shoto
        dynamic_comAllClear();
        dynamic_segAllClear();
        
        M_seg = 1;
        
        break;
    case 1:                               // common1 shuturyoku
        dynamic_comAllClear();
        dynamic_segDataSet(D_7seg[0]);
        com_1 = 1;
        
        M_seg = 2;
        break;
    case 2:                              // common2 shuturyoku
        dynamic_comAllClear();
        dynamic_segDataSet(D_7seg[1]);
        com_2 = 1;
        
        M_seg = 3;
        break;
    case 3:                             // common3 shuturyoku
        dynamic_comAllClear();
        dynamic_segDataSet(D_7seg[2]);
        com_3 = 1;
        
        M_seg = 4;
        break;
    case 4:                             // common4 shuturyoku
        dynamic_comAllClear();
        dynamic_segDataSet(D_7seg[3]);
        com_4 = 1;
        
        M_seg = 1;
        break;
    default:                           // M_seg no atai ga ijo no tokino shori
        dynamic_comAllClear();
        dynamic_segAllClear();
        M_seg = 1;
        break;
       
    }
        
}
