#include "pancake.hpp"

Pancake::Pancake(PinName tx,PinName rx) : pc(tx,rx){
    pc.baud(115200);
    }
    
void Pancake::sound1(uint8_t cn,sound_t &sound){
    uint8_t data[4]={0x0A,cn,sound.octave,sound.toneColor<<4|sound.scale};
    sendCommand(data,4);
    }

void Pancake::sound(sound_t sounds[4]){
    uint8_t data[9]={0x09,0,0,0,0,0,0,0,0};
    data[1] = sounds[0].octave;
    data[2] = sounds[0].toneColor<<4|sounds[0].scale;
    data[3] = sounds[1].octave;
    data[4] = sounds[1].toneColor<<4|sounds[1].scale;
    data[5] = sounds[2].octave;
    data[6] = sounds[2].toneColor<<4|sounds[2].scale;
    data[7] = sounds[3].octave;
    data[8] = sounds[3].toneColor<<4|sounds[3].scale;
    
    sendCommand(data,9);
    }    
    
void Pancake::setMusic(uint8_t channel,bool mode,uint8_t tempo,
                        uint8_t toneColor,uint8_t score[],uint8_t scoreSize){
    uint8_t data[3+scoreSize];
    data[0] = 0x0b;//command code
    data[1] = channel;
    data[2] = mode;
    data[3] = (tempo<<4)|toneColor;
    for(uint8_t i= 4;i < scoreSize + 4;i++){
        data[i] = score[i - 4];
        }
    
    sendCommand(data,scoreSize + 4);
    }

void Pancake::playMusic(){
    uint8_t data[2]={0x0c,0x01};
    sendCommand(data,2);
    }
    
void Pancake::stopMusic(){
    uint8_t data[2]={0x0c,0x00};
    sendCommand(data,2);
    }
 
void Pancake::clearScreen(P_Color color){
     uint8_t data[2] = {0x00,uint8_t(color)};
     sendCommand(data,2);
     }
 
void Pancake::writeLine(uint8_t sx,uint8_t sy,uint8_t ex,uint8_t ey,
                        P_Color color){
    uint8_t data[6] = {0x01,sx,sy,ex,ey,uint8_t(color)};
    sendCommand(data,6);
    }
    
void Pancake::writeCircle(uint8_t centerx,uint8_t centery,uint8_t radius,P_Color color){
    uint8_t data[5] = {0x0e,centerx,centery,radius,uint8_t(color)};
    sendCommand(data,5);
    }
 
 
 
    
void Pancake::sendCommand(uint8_t data[],uint8_t length)
{
    uint8_t i = 0;
    pc.putc(0x80);
    pc.putc(length + 2);
    
    while(i < length ){
        pc.putc(data[i]);
        i++;
        }
    }