#include "mbed.h"

typedef enum Pancake_Color{
    P_Black,
    P_White,
    P_Red,
    P_Peach,
    P_Orange,
    P_Yellow,
    P_PaleBrown,
    P_Brown,
    P_YellowGreen,
    P_Green,
    P_LiteBlue,
    P_Bule,
    P_DarkBule,
    P_BluePurple,
    P_RedPurple,
    P_Gray
    }P_Color;
typedef enum Pancake_Image{
    P_Pancake,
    P_Grassland,
    P_Road,
    P_Wilderness,
    P_Sea,
    P_Sky,
    P_Space,
    P_Castle
    }P_Image;
class sound_t{
    public:
    sound_t()
   {
   }

   sound_t(uint8_t oc,uint8_t sc,uint8_t tc) 
   {
       octave = oc;
       scale = sc;
       toneColor = tc; 
   }
    
    uint8_t octave;
    uint8_t scale;
    uint8_t toneColor;
    };


class Pancake {
    public:
    Pancake(PinName tx,PinName rx);
    //~Pancake();
    void sound1(uint8_t cn,sound_t &sound);
    void sound(sound_t sounds[4]);
    void setMusic(uint8_t channel,bool mode,uint8_t tempo,
                    uint8_t toneColor,uint8_t score[],uint8_t size);
    void playMusic();
    void stopMusic();
    void reset();
    
    void clearScreen(P_Color color);
    void writeLine(uint8_t sx,uint8_t sy,uint8_t ex,uint8_t ey,P_Color color);
    void writeCircle(uint8_t centerx,uint8_t centery,uint8_t radius,P_Color color);
    void writeStamp();
    void writeImage();

    private:
    void sendCommand(uint8_t data[],uint8_t length);
    Serial pc;
    uint8_t spriteMode;
};
